!=======================================================================
      subroutine solENO(nt,nx,level,idsol,idCENO,ierr,scheme,
     &                 at,bt,ax,bx,vel,U,ENO,wksp)
!=======================================================================
      implicit none
      integer nt,nx,level,idsol,idCENO,ierr
      real*8  at,bt,ax,bx,vel
      real*8  U(0:nx,0:1),ENO(0:nx,*),wksp(0:nx,*)
      character*40 scheme

!---- local variables

      integer i,j,n,nxm1
      integer id0,id1,id_eno
      real*8  ht,hx,rhx,halfht,hx4th
      real*8  eno2fac,eno3fac

!---- print out information

      if(level.ge.1)then
          print'("SOL_ENO: idsol="i2,", ",a40)',idsol,scheme
      endif

!---- basic setting

      hx=(bx-ax)/dble(nx)
      ht=(bt-at)/dble(nt)

      nxm1=nx-1
      rhx=1.d0/hx
      halfht=0.5d0*ht
      hx4th=0.25d0*hx

      if(vel.ge.0.d0) then
          id_eno=-1
          eno2fac=0.5d0*hx
      else
          id_eno=1
          eno2fac=-0.5d0*hx
      endif

      eno3fac=-hx**2/6.d0


!------------------------------
! Time-marching
!------------------------------

      goto(10,20,30,40,50),idsol

!------------------
!---- ENO1-Euler
!------------------
 10   continue
      do n=1,nt

          call eno123(nx,id_eno,1,idCENO,hx,eno2fac,eno3fac,
     &                U(0,0),ENO,wksp)
          do i=0,nx
              U(i,0)=U(i,0)+ht*(-vel*ENO(i,1))
          enddo

      enddo
      return

!------------------
!---- ENO2-RK2
!------------------
 20   continue
      do n=1,nt

          call eno123(nx,id_eno,2,idCENO,hx,eno2fac,eno3fac,
     &                U(0,0),ENO,wksp)
          do i=0,nx
              U(i,1)=U(i,0)+ht*(-vel*ENO(i,1))
          enddo

          call eno123(nx,id_eno,2,idCENO,hx,eno2fac,eno3fac,
     &                U(0,1),ENO,wksp)
          do i=0,nx
              U(i,0)=0.5d0*( U(i,0)+U(i,1)+ht*(-vel*ENO(i,1)) )
          enddo

      enddo
      return

!------------------
!---- ENO3-RK2
!------------------
 30   continue
      do n=1,nt

          call eno123(nx,id_eno,3,idCENO,hx,eno2fac,eno3fac,
     &                U(0,0),ENO,wksp)
          do i=0,nx
              U(i,1)=U(i,0)+ht*(-vel*ENO(i,1))
          enddo

          call eno123(nx,id_eno,3,idCENO,hx,eno2fac,eno3fac,
     &                U(0,1),ENO,wksp)
          do i=0,nx
              U(i,0)=0.5d0*( U(i,0)+U(i,1)+ht*(-vel*ENO(i,1)) )
          enddo

      enddo
      return

!------------------
!---- ENO3-RK3
!------------------
 40   continue
      do n=1,nt

          call eno123(nx,id_eno,3,idCENO,hx,eno2fac,eno3fac,
     &                     U(0,0),ENO(0,1),wksp)
          do i=0,nx
              U(i,1)=U(i,0)+halfht*(-vel*ENO(i,1))
          enddo

          call eno123(nx,id_eno,3,idCENO,hx,eno2fac,eno3fac,
     &                     U(0,1),ENO(0,2),wksp)
          do i=0,nx
              U(i,1)=U(i,0)+0.75d0*ht*(-vel*ENO(i,2))
          enddo
          call eno123(nx,id_eno,3,idCENO,hx,eno2fac,eno3fac,
     &                     U(0,1),ENO(0,3),wksp)

          do i=0,nx
              U(i,0)=U(i,0) + ((-vel)*ht/9.d0)
     &               *(2.d0*ENO(i,1)+3.d0*ENO(i,2)+4.d0*ENO(i,3))
          enddo

      enddo
      return

!-------------------
!---- Order2-LaxFri
!-------------------
 50   continue
      do n=1,nt

          id0=mod(n+1,2)
          id1=mod(n,2)

          call DMM(nx,hx,U(0,id0),ENO(0,1))
          do i=0,nx
              U(i,id1)=U(i,id0)+halfht*(-vel*ENO(i,1))
          enddo

          call D0(nx,hx,U(0,id1),ENO(0,2))

          do i=1,nxm1
              U(i,id1)=0.5d0*(U(i-1,id0)+U(i+1,id0))
     &              -hx4th*(ENO(i+1,1)-ENO(i-1,1))
     &              +ht*(-vel*ENO(i,2))
          enddo
          U(0,id1)=U(1,id1)
          U(nx,id1)=U(nxm1,id1)

      enddo
      if(id1.ne.0)then
      do i=0,nx
          U(i,0)=U(i,id1)
      enddo
      endif
      return

      end

