c ======================================================================
      subroutine setU0(nx,n_init,nwA,level,ierr,ax,bx,vel,U)
c ======================================================================
      implicit none
      integer nx,n_init,nwA,level,ierr
      real*8  ax,bx,vel,U(0:nx)

      integer j,n0,n1
      real*8  hx,a0,a1,px

      if(level.ge.2) print'("SET_U0: n_init=",i2)',n_init

!---- basic setting

      hx=(bx-ax)/dble(nx)

!---- setting "U0"

      do j=0,nx
         U(j)=0.d0
      enddo

      if(n_init.eq.1)then

          if(vel.gt.0.d0) then
              a0=ax+min(1.d0,0.2d0*(bx-ax))
              a1=ax+min(2.d0,0.4d0*(bx-ax))
          else
              a0=bx-min(2.d0,0.4d0*(bx-ax))
              a1=bx-min(1.d0,0.2d0*(bx-ax))
          endif
          n0=max(1,nint((a0-ax)/hx))
          n1=min(nx-1,nint((a1-ax)/hx))
          do j=n0,n1
             U(j)=1.d0
          enddo
          if(level.le.1) return
          if(n0.gt.n1) then
              print*,"***** U0 = 0, completely *****"
          else
              print*,"U0=1: from",a0," to",a1
          endif

      else if(n_init.eq.2) then

          a0=2.d0
          do j=0,nx
             px=ax+dble(j)*hx
             if(dabs(px-(ax+a0)).le.1.d0)then
                 U(j)=1.d0-dabs(px-(ax+a0))
             endif
          enddo

      else if(n_init.eq.3) then

          a0=ax+1.d0
          a1=ax+2.d0
          n0=max(1,nint((a0-ax)/hx))
          n1=min(nx-1,nint((a1-ax)/hx))
          do j=n0,n1
             U(j)=1.d0
          enddo

          a0=4.d0
          do j=0,nx
             px=ax+dble(j)*hx
             if(dabs(px-(ax+a0)).le.1.d0)then
                 U(j)=1.d0-dabs(px-(ax+a0))
             endif
          enddo

      else if(n_init.eq.4) then

          do j=0,nx
             px=ax+dble(j)*hx
             if(px.ge.0.4d0 .and. px.le.0.6d0)then
                 U(j)=1.d0
             endif
          enddo

      else if(n_init.eq.5)then

          if(vel.gt.0.d0) then
              a0=ax+min(1.d0,0.2d0*(bx-ax))
              a1=ax+min(4.d0,0.5d0*(bx-ax))
          else
              a0=bx-min(4.d0,0.5d0*(bx-ax))
              a1=bx-min(1.d0,0.2d0*(bx-ax))
          endif
          n0=max(1,nint((a0-ax)/hx))
          n1=min(nx-1,nint((a1-ax)/hx))
          do j=n0,n1
             U(j)=0.5d0*(1.d0+dcos(dble(j)*hx*6.283))
          enddo
      else
          print*,"Error: setU0.f: wrong n_init"
          ierr=1
          return
      endif

      return
      end

