!=======================================================================
      subroutine eno123(nx,id_eno,iorder,idCENO,hx,eno2fac,eno3fac,
     &                  U,ENO,wksp)
!=======================================================================
      implicit none
      integer nx,id_eno,iorder,idCENO
      real*8  hx,eno2fac,eno3fac
      real*8  U(0:nx),ENO(0:nx),wksp(0:nx,*)

      integer i
      real*8  a,b,eno3fac2

!---- ENO1

      call D1(nx,id_eno,hx,U,ENO)
      if(iorder.eq.1) return

!---- ENO2

      call D1(nx,(-id_eno),hx,ENO,wksp(0,1))
      call MM2(nx,id_eno,idCENO,wksp(0,1),wksp(0,2))

      do i=0,nx
          ENO(i)=ENO(i)+eno2fac*wksp(i,2)
      enddo
      if(iorder.eq.2) return

!---- ENO3

      call D1(nx,id_eno,hx,wksp(0,1),wksp(0,2)) !(D^-D^+D^-) or (D^+D^-D^+)
      call MM3(nx,id_eno,idCENO,wksp(0,2),wksp(0,3))

*      if(idCENO.eq.1)then
*          do i=0,nx
*              ENO(i)=ENO(i)+eno3fac*wksp(i,3)
*          enddo
*      else
          eno3fac2=hx**2/3.d0
          do i=0,nx
              a=wksp(i,1)
              b=wksp((max(min(i+id_eno,nx),0)),1)
              if (dabs(a).le.dabs(b))then
                  ENO(i)=ENO(i)+eno3fac*wksp(i,3)
              else
                  ENO(i)=ENO(i)+eno3fac2*wksp(i,3)
              endif

          enddo
*      endif

      return
      end

!=======================================================================
      subroutine D1(nx,id_eno,hx,u,Du)
!=======================================================================
      implicit none
      integer nx,id_eno
      real*8  hx,u(0:nx),Du(0:nx)

      integer i
      real*8  rhx
      rhx=1.d0/hx

      if(id_eno.eq.(-1))then
          do i=1,nx
              Du(i)=(u(i)-u(i-1))*rhx
          enddo
          Du(0)=Du(1)
      else if(id_eno.eq.1)then
          do i=0,nx-1
              Du(i)=(u(i+1)-u(i))*rhx
          enddo
          Du(nx)=Du(nx-1)
      else
          stop 'D1: error in id_eno'
      endif

      return
      end

!=======================================================================
      subroutine D0(nx,hx,u,Du)
!=======================================================================
      implicit none
      integer nx
      real*8  hx,u(0:nx),Du(0:nx)

      integer i,nxm1
      real*8  r2hx

      nxm1=nx-1
      r2hx=1.d0/(2.d0*hx)

      do i=1,nxm1
          Du(i)=(u(i+1)-u(i-1))*r2hx
      enddo

      Du(0)=Du(1)
      Du(nx)=Du(nxm1)

      return
      end

!=======================================================================
      subroutine MM2(nx,id_eno,idCENO,u,v)
!=======================================================================
      implicit none
      integer nx,id_eno,idCENO
      real*8  u(0:nx),v(0:nx)

      integer i,i0,i1
      real*8  a,b,zero

      zero=0.d0
      if(id_eno.eq.(-1)) then
          i0=1
          i1=nx
      else if(id_eno.eq.1) then
          i0=0
          i1=nx-1
      else
          stop 'MM2: error in id_eno'
      endif

      if(idCENO.eq.1) then
          do i=i0,i1
              a=u(i)
              b=u(i+id_eno)
              if((a*b).le.zero)then
                  v(i)=zero
              else
                  if (dabs(a).le.dabs(b))then
                      v(i)=a
                  else
                      v(i)=b
                  endif
              endif
          enddo
      else
          do i=i0,i1
              a=u(i)
              b=u(i+id_eno)
              if (dabs(a).le.dabs(b))then
                  v(i)=a
              else
                  v(i)=b
              endif
          enddo
      endif

      if(id_eno.eq.(-1)) v(0)=v(1)
      if(id_eno.eq.1) v(nx)=v(nx-1)

      return
      end

!=======================================================================
      subroutine MM3(nx,id_eno,idCENO,u,v)
!=======================================================================
      implicit none
      integer nx,id_eno,idCENO
      real*8  u(0:nx),v(0:nx)

      integer i,nxm1
      real*8  a,b,c,zero

      nxm1=nx-1
      zero=0.d0

      do i=1,nxm1
          a=u(i-1)
          b=u(i)
          c=u(i+1)
          if(idCENO.eq.1)then
              if(a.ge.zero .and. b.ge.zero .and. c.ge.zero)then
                  v(i)=min(a,b,c)
              else if (a.le.zero .and. b.le.zero .and. c.le.zero)then
                  v(i)=max(a,b,c)
              else
                  v(i)=zero
              endif
          else
              if(dabs(b).le.dabs(a)) a=b
              if(dabs(c).le.dabs(a)) a=c
              v(i)=a
          endif

      enddo

      v(0)=v(1)
      v(nx)=v(nx-1)

      return
      end

!=======================================================================
      subroutine DMM(nx,hx,u,Du)
!=======================================================================
      implicit none
      integer nx
      real*8  hx,u(0:nx),Du(0:nx)

      integer i,nxm1
      real*8  a,b,c,rhx,zero

      nxm1=nx-1
      rhx=1.d0/hx
      zero=0.d0

      do i=1,nxm1
          a=(u(i)-u(i-1))*rhx
          c=(u(i+1)-u(i))*rhx
          b=0.5d0*(a+c)
          if(a.ge.zero .and. b.ge.zero .and. c.ge.zero)then
              Du(i)=min(a,b,c)
          else if (a.le.zero .and. b.le.zero .and. c.le.zero)then
              Du(i)=max(a,b,c)
          else
              Du(i)=zero
          endif
      enddo

      Du(0)=Du(1)
      Du(nx)=Du(nxm1)

      return
      end

