c ======================================================================
      subroutine getBF(nx,nt,nwA,idsol,level,ierr,
     &           ax,bx,at,bt,theta, A,B,F)
c ======================================================================
      implicit none
      integer nx,nt,nwA,idsol,level,ierr
      real*8  ax,bx,at,bt,theta
      real*8  A(nwA,0:nx),B(nwA,0:nx),F(nwA,0:nx)

!-- if(idsol.eq.1) scheme='Upwind'
!-- if(idsol.eq.2) scheme='Central-Space'
!-- if(idsol.eq.3) scheme='Third-Order'
!-- if(idsol.eq.4) scheme='LeapFrog'
!-- if(idsol.eq.5) scheme='Lax-Friedrichs'

      integer i,j,id_blend
      real*8  hx,ht,twoht,onemth
      real*8  blend,blendm1

      if(level.ge.2) print'("GET_BF: idsol=",i2)',idsol

!---- basic setting

      hx=(bx-ax)/dble(nx)
      ht=(bt-at)/dble(nt)
      twoht=2.d0*ht
      onemth=1.d0-theta

      blend=0.d0
      blendm1=1.d0-blend

      id_blend=0

!-----------------------------------------------
!---- Get "B" and "F" depending on given idsol.
!-----------------------------------------------

      goto(10,10,30,40,50),idsol

!---------------------------------------
 10   continue

      if(nwA.eq.3)then

          if(id_blend.eq.1 .and. idsol.eq.2)then
              blend=0.5d0              ! blend=0: purely second-order
              blendm1=1.d0-blend
          endif

          do j=0,nx

              B(1,j)=     theta*ht*A(1,j)
              B(2,j)=1.d0+theta*ht*A(2,j)
              B(3,j)=     theta*ht*A(3,j)

*              F(1,j)=    -onemth*ht*A(1,j)
*              F(2,j)=1.d0-onemth*ht*A(2,j)
*              F(3,j)=    -onemth*ht*A(3,j)

              F(1,j)=0.25d0*blend         -onemth*ht*A(1,j)
              F(2,j)=0.50d0*blend +blendm1-onemth*ht*A(2,j)
              F(3,j)=0.25d0*blend         -onemth*ht*A(3,j)

          enddo

      elseif(nwA.eq.5)then
          ierr=1
          return
      endif
      return

!---------------------------------------
 30   continue

      if(nwA.eq.3)then
          ierr=1
          return
      elseif(nwA.eq.5)then

          if(id_blend.eq.1) then
              blend=0.25d0             ! blend=0: purely third-order
              blendm1=1.d0-blend
          endif

          do j=0,nx

              B(1,j)=     theta*ht*A(1,j)
              B(2,j)=     theta*ht*A(2,j)
              B(3,j)=1.d0+theta*ht*A(3,j)
              B(4,j)=     theta*ht*A(4,j)
              B(5,j)=     theta*ht*A(5,j)

              F(1,j)=    -onemth*ht*A(1,j)
*              F(2,j)=    -onemth*ht*A(2,j)
*              F(3,j)=1.d0-onemth*ht*A(3,j)
*              F(4,j)=    -onemth*ht*A(4,j)
              F(5,j)=    -onemth*ht*A(5,j)

              F(2,j)=0.25d0*blend         -onemth*ht*A(2,j)
              F(3,j)=0.50d0*blend +blendm1-onemth*ht*A(3,j)
              F(4,j)=0.25d0*blend         -onemth*ht*A(4,j)

          enddo

      endif
      return

!---------------------------------------
 40   continue

      if(nwA.eq.3)then

          do j=0,nx
              B(1,j)=0.d0
              B(2,j)=1.d0
              B(3,j)=0.d0
              F(1,j)=-twoht*A(1,j)
              F(2,j)=-twoht*A(2,j)
              F(3,j)=-twoht*A(3,j)
          enddo

      elseif(nwA.eq.5)then
          ierr=1
          return
      endif
      return

!---------------------------------------
 50   continue

      if(nwA.eq.3)then

          do j=0,nx
              B(1,j)=0.d0
              B(2,j)=1.d0
              B(3,j)=0.d0
              F(1,j)=0.5d0-ht*A(1,j)
              F(2,j)=     -ht*A(2,j)
              F(3,j)=0.5d0-ht*A(3,j)
          enddo

      elseif(nwA.eq.5)then
          ierr=1
          return
      endif
      return

      end

