c ======================================================================
      subroutine getA(nx,nwA,idsol,level,ierr,ax,bx,vel,epsilon,A)
c ======================================================================
      implicit none
      integer nx,nwA,idsol,level,ierr
      real*8  ax,bx,vel,epsilon,A(nwA,0:nx)

!-- if(idsol.eq.1) scheme='Upwind'
!-- if(idsol.eq.2) scheme='Central-Space'
!-- if(idsol.eq.3) scheme='Third-Order'
!-- if(idsol.eq.4) scheme='LeapFrog'
!-- if(idsol.eq.5) scheme='Lax-Friedrichs'

      integer i,j
      real*8  hx,rhx,r2hx,r6hx,d1

      if(level.ge.2)then
          print'("GET_A: idsol=",i2)',idsol
          print*,"vel=",vel," epsilon=",epsilon
      endif

!---- basic setting

      hx=(bx-ax)/dble(nx)
      rhx =1.d0/hx
      r2hx=1.d0/(2.d0*hx)
      r6hx=1.d0/(6.d0*hx)

      d1=epsilon/(hx**2)

      if(nwA.eq.3)then
          do j=0,nx
              A(1,j)=-d1
              A(2,j)=2.d0*d1
              A(3,j)=-d1
          enddo
      else
          do j=0,nx
              A(1,j)=0.d0
              A(2,j)=-d1
              A(3,j)=2.d0*d1
              A(4,j)=-d1
              A(5,j)=0.d0
          enddo
      endif


!==========================================
!---- Get "A" depending on given idsol.
!==========================================

      goto(10,20,30,20,20),idsol

!---------------------------------------
!---- one-sided spatial discretization
!---------------------------------------
 10   continue

      if(nwA.eq.3)then

          do j=0,nx
              if(vel.ge.0.d0) then
                  A(1,j)=A(1,j)-vel*rhx
                  A(2,j)=A(2,j)+vel*rhx
              else
                  A(2,j)=A(2,j)-vel*rhx
                  A(3,j)=A(3,j)+vel*rhx
              endif
          enddo

      elseif(nwA.eq.5)then
          ierr=1
          return
      endif
      return

!---------------------------------------
!---- central spatial discretization
!---------------------------------------
 20   continue

      if(nwA.eq.3)then

          do j=0,nx
              A(1,j)=A(1,j)-vel*r2hx
              A(3,j)=A(3,j)+vel*r2hx
          enddo

      elseif(nwA.eq.5)then
          ierr=1
          return
      endif
      return

!---------------------------------------
!---- Third-order spatial discretization
!---------------------------------------
 30   continue

      if(nwA.eq.3)then
          ierr=1
          return
      elseif(nwA.eq.5)then

          if(vel.ge.0.d0)then
              do j=0,nx
                  A(1,j)=A(1,j)+vel*r6hx
                  A(2,j)=A(2,j)-vel*r6hx*6.d0
                  A(3,j)=A(3,j)+vel*r6hx*3.d0
                  A(4,j)=A(4,j)+vel*r6hx*2.d0
              enddo
          else
              do j=0,nx
                  A(2,j)=A(2,j)-vel*r6hx*2.d0
                  A(3,j)=A(3,j)-vel*r6hx*3.d0
                  A(4,j)=A(4,j)+vel*r6hx*6.d0
                  A(5,j)=A(5,j)-vel*r6hx
              enddo
          endif

      endif
      return

      end

