!=======================================================================
      subroutine wave1D(nt,nx,n_init,nwA,level,
     &     idsol,idCENO,idstagger,idnumer,ierr,
     &     at,bt,ax,bx,vel,epsilon,theta,
     &     A,B,F,U,ENO,wksp)
!=======================================================================
      implicit none
      integer nt,nx,n_init,nwA,level
      integer idsol,idCENO,idstagger,idnumer,ierr
      real*8  at,bt,ax,bx,vel,epsilon,theta
      real*8  A(nwA,0:nx),B(nwA,0:nx),F(nwA,0:nx),U(0:nx,0:1)
      real*8  ENO(0:nx,*),wksp(0:nx)

!------------------------------------------------------
! WAVE.1D
! Edited: 5/7,2001
!------------------------------------------------------
!-- This program solves
!--    u_t + vel*u_{x} - epsilon*u_{xx} = 0.
!-- Let matrix A represent the spatial discretization.
!-- Then, the discretization reads
!--    B U^{n} = F U^{n-1}
!-- where B=(I+theta*k*A) and F=(I-(1.-theta)*k*A).
!------------------------------------------------------
! Spatial Discretizations
!------------------------------------------------------
!-- if(idsol.eq.1)  scheme='Upwind'
!-- if(idsol.eq.2)  scheme='Central-Space'
!-- if(idsol.eq.3)  scheme='Third-Order'
!-- if(idsol.eq.4)  scheme='LeapFrog'
!-- if(idsol.eq.5)  scheme='Lax-Friedrichs'
!-- if(idsol.eq.11) scheme='ENO1'
!-- if(idsol.eq.12) scheme='ENO2'
!-- if(idsol.eq.13) scheme='ENO3'
!-- if(idsol.eq.15) scheme='Order2-LxF'
!-- if(idsol.eq.22) scheme='ENO2-CN'
!-- if(idsol.eq.23) scheme='ENO3-CN'
!------------------------------------------------------
! Theta
!------------------------------------------------------
!-- if(theta.eq.0.0) Forward
!-- if(theta.eq.0.5) Crank-Nicolson
!-- if(theta.eq.1.0) Backward
!-- Note: "theta>0" works for only idsol=1, 2, 3, 22, and 23


!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,n,id0,id1,id_eno,initpr
      integer level0,idsol1,nshift,js,nband,idsolm10
      real*8  eps0
      real*8  ht,hx,lambda
      real*8  eno2fac,eno3fac
      character*40 scheme

!------------------------------------
!---- basic checking and setting
!------------------------------------

      eps0=1.d-6
      nband=nwA/2
      level0=0
      scheme='NONE'

      if(idsol.eq.1)  scheme='Upwind'
      if(idsol.eq.2)  scheme='Central-Space'
      if(idsol.eq.3)  scheme='Third-Order'
      if(idsol.eq.4)  scheme='LeapFrog'
      if(idsol.eq.5)  scheme='Lax-Friedrichs'

      if(idsol.eq.11) scheme='ENO1-Euler'
      if(idsol.eq.12) scheme='ENO2-RK2'
      if(idsol.eq.13) scheme='ENO3-RK2'
      if(idsol.eq.14) scheme='ENO3-RK3'
      if(idsol.eq.15) scheme='Order2-LxF'

      if(idsol.eq.22) scheme='ENO2-CN'
      if(idsol.eq.23) scheme='ENO3-CN'

      if(idCENO.eq.1)then
      if(idsol.eq.12) scheme='CU2-RK2'
      if(idsol.eq.13) scheme='CU3-RK2'
      if(idsol.eq.14) scheme='CU3-RK3'
      if(idsol.eq.22) scheme='CU2-CN'
      if(idsol.eq.23) scheme='CU3-CN'
      endif

      if(scheme.eq.'NONE')then
          print*,"Error: Wave1D.f: Wrong idsol"
          ierr=1
          return
      endif

      if( min(dabs(theta-0.0d0),dabs(theta-0.5d0),dabs(theta-1.0d0))
     &         .gt.eps0 ) then
          print*,"Error: Wave1D.f: theta must be 0.0, 0.5, or 1.0."
          ierr=1
          return
      endif

      if(idsol.ge.4 .and. idsol.le.20) theta=0.d0
*      if(idsol.ge.11) epsilon=0.d0

      hx=(bx-ax)/dble(nx)
      ht=(bt-at)/dble(nt)

      lambda=ht/hx

      if( (theta.le.eps0 .and. dabs(vel*lambda).gt.1.d0) .or.
     &    (idsol.eq.2 .and. theta.lt.eps0) )then
          print*,"|vel*lambda|=",dabs(vel*lambda)
          print'(1x,40("-"))'
          print*,"Error: Wave1D.f: Stability violated."
          print'(1x,40("-"))'
          ! ierr=1
          ! return
      endif

      idsol1=mod(idsol,10)
      if(idsol.eq.4) idsol1=1  !for initialization of LeapFrog

      idsolm10=mod(idsol,10)

      if(vel.ge.0.d0) then
          id_eno=-1
          eno2fac=0.5d0*hx
      else
          id_eno=1
          eno2fac=-0.5d0*hx
      endif
      eno3fac=-hx**2/6.d0

      initpr=0
      if(n_init.ge.3) initpr=nint((vel*bt-1.d0)/hx)


!------------------------------------
!---- Print out information
!------------------------------------

      if(level.ge.1)then
         print'("WAVE_1D: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.2)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"vel=",vel," epsilon=",epsilon," nwA=",nwA
         print*,"theta=",theta," idstagger=",idstagger
     &         ," idnumer=",idnumer
         print*,"|vel*lambda|=",dabs(vel*lambda)
      endif


!------------------------------------
!---- Set initial values
!------------------------------------

      call setU0(nx,n_init,nwA,level,ierr,ax,bx,vel,U)

      do j=0,nx
          U(j,1)=0.d0
      enddo

      nshift=nint(vel*(bt-at)/hx)
      do j=0,nx
          js=j-nshift
          if(js.lt.0)then
              wksp(j)=U(0,0)
          else if(js.gt.nx)then
              wksp(j)=U(nx,0)
          else
              wksp(j)=U(js,0)
          endif
      enddo

      if(level.ge.2)then
          open(68,file="fort.true")
          print*,"<fort.true> contains the true solution at t=",bt
          do j=initpr,nx
             write(68,*) ax+dble(j)*hx,wksp(j)
          enddo
          close(68)
      endif


!=====================================================
!---- "ENO" schemes (idsol.ge.11 .and. idsol.le.20)
!=====================================================

      if(idsol.ge.11 .and. idsol.le.20)then
          call solENO(nt,nx,level,idsolm10,idCENO,ierr,scheme,
     &               at,bt,ax,bx,vel,U,ENO,wksp)
          id1=0
          goto 9999
      endif


!==========================================
!---- Other Standard Schemes (idsol.le.10)
!==========================================

!------------------------------------
!---- Construct "A"
!------------------------------------

      call getA(nx,nwA,idsol1,level,ierr,ax,bx,vel,epsilon,A)

      if(ierr.ne.0)then
          print*,"Error: Wave1D.f: from getA"
          return
      endif


!------------------------------------
!---- Construct "B" and "F"
!------------------------------------

      call getBF(nx,nt,nwA,idsol1,level,ierr,
     &           ax,bx,at,bt,theta, A,B,F)

      if(ierr.ne.0)then
          print*,"Error: Wave1D.f: from getBF"
          return
      endif

!------------------------------------
!---- Set Neumann Boundary Condition
!------------------------------------

      if(theta.ge.eps0) call neumannBC(nx,nwA,level,B)
      call neumannBC(nx,nwA,level,F)

      if(theta.gt.eps0)then
          call lufac(nband,nx+1,level0,B)
      endif

!------------------------------------
!---- Now, time-marching
!------------------------------------

      do 8888 n=1,nt

          id0=mod(n+1,2)
          id1=mod(n,2)

*          if(nt.ge.10000)then
*          if(level.ge.1 .and. mod(n,1000).eq.0)then
*              print*,"n=",n," t=",dble(n)*ht
*          endif
*          endif

          if(idsol.le.10)then
              call FU(nx,nwA,idsol1,level0,ierr,F,U(0,id0),U(0,id1))
          else
              call eno123(nx,id_eno,idsolm10,idCENO,hx,eno2fac,eno3fac,
     &                    U(0,id0),ENO,wksp)
              do i=0,nx
                  U(i,id1)=U(i,id0)+theta*ht*(-vel*ENO(i,1))
              enddo
          endif


          if(n.eq.1 .and. idsol.eq.4) then
              call getA(nx,nwA,idsol,level,ierr,ax,bx,vel,epsilon,A)
              call getBF(nx,nt,nwA,idsol,level,ierr,
     &                   ax,bx,at,bt,theta, A,B,F)
              call neumannBC(nx,nwA,level,F)
              idsol1=idsol
              goto 8888
          endif

          if(theta.gt.eps0)then
              call substit(nband,nx+1,level0,B,U(0,id1))
          endif

 8888 continue


!------------------------------------
!---- Print out the results
!------------------------------------

 9999 if(level.le.1) return

      open(1,file="fort.0")
         write(1,*) scheme
      close(1)
      open(1,file="fort.1")
         write(1,*) nx,ax,bx,hx,nt,at,bt,ht,theta
      close(1)

      open(68,file="fort.sol")
      print*,"<fort.sol>  contains computed solution at t=",bt
      do j=initpr,nx
         write(68,*) ax+dble(j)*hx,U(j,id1)
      enddo
      close(68)

      return
      end
