!=======================================================================
      subroutine transport(nx,ny,nt,it,mptcl,nspcs,level,ierr,
     &      idualmesh,idsol,numerical,
     &      ax,ay,ht,tn,hx,hy, NPT,ptcl,vel,xbar)
!=======================================================================
      implicit none
      integer nx,ny,nt,it,mptcl,nspcs,level,ierr
      integer idualmesh,idsol,numerical
      real*8  ax,ay,ht,tn,hx,hy
      integer NPT(nx,ny,2)
      real*8  ptcl((2+nspcs),mptcl,nx,ny,2)
      real*8  vel(2,0:nx,0:ny),xbar(2,0:nx,0:ny)


!---- Information interface

      if(level.ge.1) print'("TRANSPORT: @tn=",f8.4)',tn
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny," it=",it
         print*,"idualmesh=",idualmesh," idsol=",idsol
      endif


!------------------------
!---- Numerical test
!------------------------

      if(numerical.eq.1) then

         call dualmesh(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &         NPT,ptcl,xbar)

         call ptprint(nx,ny,mptcl,nspcs,level,it,nt,ierr,
     &         ax,ay,ht,tn,hx,hy,NPT,ptcl,vel,xbar)

         return
      endif


!------------------------
!---- Transport
!------------------------

      if(idualmesh.ge.1)then

         call dualmesh(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &         NPT,ptcl,xbar)

      else

         if(idsol.eq.1)then

            call euler(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &                NPT,ptcl,vel)

         elseif(idsol.eq.4)then

            call rk4(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &                NPT,ptcl,vel)

         endif

      endif



      return
      end

