!=======================================================================
      subroutine timemarch(nt,nx,ny,auto_dt,nconv,ndiff,nreact,nbc,nvel,
     &     intpol1,intpol2,lastIntpol,iptcl,mptcl,nspcs,
     &     idualmesh,numerical,idsol,level,itmax,ierr,
     &     ht,hx,hy,sigma,epsilon, at,bt,ax,bx,ay,by,tol,
     &     NPT,ptcl,con,vel,xbar,A1,A2,A5,b,wksp)
!=======================================================================
      implicit none
      integer nt,nx,ny,auto_dt,nconv,ndiff,nreact,nbc,nvel
      integer intpol1,intpol2,lastIntpol,iptcl,mptcl,nspcs
      integer idualmesh,numerical,idsol,level,itmax,ierr
      real*8  ht,hx,hy,sigma,epsilon, at,bt,ax,bx,ay,by,tol
      integer NPT(nx,ny,2)
      real*8  ptcl((2+nspcs),mptcl,nx,ny,2),con(nx,ny)
      real*8  vel(2,0:nx,0:ny),xbar(2,0:nx,0:ny)
      real*8  A1(3,nx,ny),A2(3,ny,nx),A5(5,nx,ny,2)
      real*8  b(*),wksp(*)

!---- local variables

      integer ix,iy,it,is,level0,NPT_tot,NPT_max,jump
      real*8  tn,time
      integer iterPCG,iterPCG_max,iterPCG_tot

!---- Informing: stdout

      if(level.ge.1)print'("TIMEMARCH: lastIntpol=",i1," mptcl=",i2)',
     &                      lastIntpol,mptcl
      if(level.ge.2) then
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nconv=",nconv," ndiff=",ndiff," nreact=",nreact
         print*,"nbc=",nbc," nvel=",nvel," itmax=",itmax," tol=",tol
         print*,"idualmesh=",idualmesh," numerical=",numerical
     &         ," sigma=",sigma," epsilon=",epsilon
      endif

      level0=0

      iterPCG_max=0
      iterPCG_tot=0

!---- Matrix construction, if(ndiff.ne.0)

      if(ndiff.ne.0)then
         call matrix3(1,nx,ny,level0,ax,bx,ay,by,A1,ierr)
         call matrix3(2,nx,ny,level0,ax,bx,ay,by,A2,ierr)

         do iy=1,ny
         do ix=1,nx
            A5(1,ix,iy,1)=ht*A2(1,iy,ix)
            A5(2,ix,iy,1)=ht*A1(1,ix,iy)
            A5(3,ix,iy,1)=1.d0+ht*(A1(2,ix,iy)+A2(2,iy,ix))
            A5(4,ix,iy,1)=ht*A1(3,ix,iy)
            A5(5,ix,iy,1)=ht*A2(3,iy,ix)
         enddo
         enddo

         call ilu0C(nx,ny,level0,A5(1,1,1,1),A5(1,1,1,2),ierr)
      endif

      if(numerical.eq.1) then
         open(unit=88,file="fort.88")
         write(88,*) 0.d0,0.d0
      endif

      if(nt.le.100)then
         jump=5
      else if(nt.le.1000)then
         jump=50
      else if(nt.le.5000)then
         jump=200
      else
         jump=500
      endif

!---- Time marching
!-----------------------------------------------------------
      do 8888 it=1,nt
!-----------------------------------------------------------

      tn=ht*dble(it)

      if(level.ge.2.and.mod(it,jump).eq.0) then
         print'(" n=",i6,3x,"tn=",f8.3)',it,tn
      endif

      if(nvel.eq.4)then
         time=tn-0.5d0*ht
         call getvel(nx,ny,nvel,level0,hx,hy,time,ax,bx,ay,by,vel)
         call getxbar(nx,ny,idualmesh,level0,
     &             ht,hx,hy,at,ax,bx,ay,by,vel,xbar)
      endif

!--------------------------
!---- Transport part
!--------------------------
      if(nconv.eq.0)goto 2222

      call transport(nx,ny,nt,it,mptcl,nspcs,level0,ierr,
     &      idualmesh,idsol,numerical,
     &      ax,ay,ht,tn,hx,hy, NPT,ptcl,vel,xbar)


!--------------------------
!---- Duffusion part
!--------------------------
 2222 continue

      if(ndiff.eq.0) then

         if(it.eq.nt.and.lastIntpol.eq.1)then
            intpol1=1
            intpol2=3
           do is=1,nspcs
              call evalCell(1,nx,ny,iptcl,mptcl,nspcs,is,level0,
     &           intpol1,intpol2,ierr, tn,NPT,ptcl,con)
              call evalCell(2,nx,ny,iptcl,mptcl,nspcs,is,level0,
     &           intpol1,intpol2,ierr, tn,NPT,ptcl,con)
           enddo
         endif

      else

         if(it.eq.nt.and.lastIntpol.eq.1)then
            intpol1=1
            intpol2=3
         endif
         call diffusion(nx,ny,iptcl,mptcl,nspcs,level0,itmax,iterPCG,
     &       nt,it,intpol1,intpol2,ierr, hx,hy,ht,sigma,epsilon,
     &       tol,tn, NPT,ptcl,con,A5(1,1,1,1),A5(1,1,1,2),b,wksp)
         iterPCG_max=max(iterPCG_max,iterPCG)
         iterPCG_tot=iterPCG_tot+iterPCG

      endif

!--------------------------
!---- Chemical reaction
!--------------------------
      if(nreact.eq.0)goto 8888

      call reaction(nx,ny,level0,tn)


!-----------------------------------------------------------
 8888 continue
!-----------------------------------------------------------
      close(88)

      if(ndiff.eq.0)then
         call evalCell(1,nx,ny,iptcl,mptcl,nspcs,1,level,
     &     intpol1,intpol2,ierr,tn,NPT,ptcl,con)
      endif


!---- information printout

      NPT_max=0
      NPT_tot=0
      do iy=1,ny
      do ix=1,nx
         NPT_max=max(NPT_max,NPT(ix,iy,1))
         NPT_tot=NPT_tot+NPT(ix,iy,1)
      enddo
      enddo

      if(level.ge.1) then
         print'("TIMEMARCH:")'
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nconv=",nconv," ndiff=",ndiff," nreact=",nreact
     &     ," level=",level," nvel=",nvel
         print*,"intpol1=",intpol1," intpol2=",intpol2
     &          ," lastIntpol=",lastIntpol
         print*,"mptcl=",mptcl," iptcl=",iptcl," sigma=",sigma
         print*,"idualmesh=",idualmesh," idsol=",idsol
     &          ," numerical=",numerical," epsilon=",epsilon
         print*,"NPT_max=",NPT_max," NPT_tot=",NPT_tot
         print*,"iterPCG_max=",iterPCG_max," iterPCG_tot=",iterPCG_tot
      endif

      if(NPT_tot.eq.1)then
         call ptclloc(nx,ny,nspcs,mptcl,level,
     &        hx,hy,ax,bx,ay,by,tn,NPT,ptcl)
      endif

      return
      end


!=======================================================================
      subroutine ptclloc(nx,ny,nspcs,mptcl,level,
     &     hx,hy,ax,bx,ay,by,tn,NPT,ptcl)
!=======================================================================
      implicit none
      integer nx,ny,nspcs,mptcl,level
      real*8  hx,hy,ax,bx,ay,by,tn
      integer NPT(nx,ny)
      real*8  ptcl((2+nspcs),mptcl,nx,ny)

!---- local variables

      integer ix,iy
      real*8  px,py

      if(level.ge.1) print'("PTCLLOC: @tn=",f7.3)',tn

      do iy=1,ny
      do ix=1,nx
         if(NPT(ix,iy).ne.0)then
            px=dble(ix-1)*hx+ax +ptcl(1,1,ix,iy)*hx
            py=dble(iy-1)*hy+ay +ptcl(2,1,ix,iy)*hy
            print'(" Particle: @",2(f14.8))',px,py
            print*,"Distance=",dsqrt(px**2+py**2)
            print'(" Distance form (1,0)=",1pe9.2)',
     &           dsqrt((1.d0-px)**2+py**2)
         endif
      enddo
      enddo

      return
      end

