!=======================================================================
      subroutine rk4(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &      NPT,ptcl,vel)
!=======================================================================
      implicit none
      integer nx,ny,mptcl,nspcs,level,ierr
      real*8  ht,tn,hx,hy
      integer NPT(nx,ny,2)
      real*8  ptcl((2+nspcs),mptcl,nx,ny,2),vel(2,0:nx,0:ny)

!---- Local variables

      integer i,j,ixn,iyn,ipn
      integer ix,iy,is,ip,ipmax,nspcs2
      integer id1,id2
      real*8  v1,v2,v3,v4,zero,half,one,sixth
      real*8  x0,y0,px,py,v,r1
      real*8  K(2,4),scale(2)

!---- Information interface

      if(level.ge.1) print'("RK4: @tn=",f8.4)',tn
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
         print*,"mptcl=",mptcl," nspcs=",nspcs
      endif

!---- Local setting

      nspcs2=nspcs+2
      scale(1)=ht/hx
      scale(2)=ht/hy

      zero=0.d0
      half=0.5d0
      one =1.d0
      sixth=1.d0/6.d0

!-------------------------------------
!---- Individual Moving of Particles
!-------------------------------------

      id1=1
      id2=2

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy,id2)=0
      enddo
      enddo

!----------------
      do iy=1,ny
      do ix=1,nx

         ipmax=NPT(ix,iy,id1)
      do 1000 ip=1,ipmax

         x0=ptcl(1,ip,ix,iy,id1)
         y0=ptcl(2,ip,ix,iy,id1)

         px=x0
         py=y0
         r1=zero

         do j=1,4

            ixn=ix
            iyn=iy
            if(j.eq.2)then
               r1=half
            elseif(j.eq.4)then
               r1=one
            endif

            if(j.gt.1) then
               px=x0+r1*K(1,j-1)
               py=y0+r1*K(1,j-1)

               if(px.gt.one) then
                  ixn=ix+1
                  px=px-one
               elseif(px.lt.zero) then
                  ixn=ix-1
                  px=px+one
               endif
               if(ixn.lt.1 .or. ixn.gt.nx)goto 1000
      
               if(py.gt.one) then
                  iyn=iy+1
                  py=py-one
               elseif(py.lt.zero) then
                  iyn=iy-1
                  py=py+one
               endif
               if(iyn.lt.1 .or. iyn.gt.ny)goto 1000
            endif

            do i=1,2
               v1=vel(i,ixn-1,iyn-1)
               v2=vel(i,ixn,iyn-1)
               v3=vel(i,ixn-1,iyn)
               v4=vel(i,ixn,iyn)
               call interVel(v1,v2,v3,v4,px,py,v)
               K(i,j)=v*scale(i)
            enddo

         enddo

         px=x0+sixth*(K(1,1)+2.d0*(K(1,2)+K(1,3))+K(1,4))
         py=y0+sixth*(K(2,1)+2.d0*(K(2,2)+K(2,3))+K(2,4))
         ixn=ix
         iyn=iy

         if(px.gt.one) then
            ixn=ix+1
            px=px-one
         elseif(px.lt.zero) then
            ixn=ix-1
            px=px+one
         endif
         if(ixn.lt.1 .or. ixn.gt.nx)goto 1000
      
         if(py.gt.one) then
            iyn=iy+1
            py=py-one
         elseif(py.lt.zero) then
            iyn=iy-1
            py=py+one
         endif
         if(iyn.lt.1 .or. iyn.gt.ny)goto 1000

         ipn=NPT(ixn,iyn,id2)+1
         NPT(ixn,iyn,id2)=ipn
         if(ipn.gt.mptcl) stop 'rk4.f: mptcl is not enough.'
      
         ptcl(1,ipn,ixn,iyn,id2)=px
         ptcl(2,ipn,ixn,iyn,id2)=py
         do is=1,nspcs
            ptcl(2+is,ipn,ixn,iyn,id2)=ptcl(2+is,ip,ix,iy,id1)
         enddo

 1000 continue

      enddo
      enddo


!-------------------------------------
!---- Copy Back
!-------------------------------------

      id1=2
      id2=1

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy,id2)=NPT(ix,iy,id1)
         do ip=1,NPT(ix,iy,id2)
         do is=1,nspcs2
            ptcl(is,ip,ix,iy,id2)=ptcl(is,ip,ix,iy,id1)
         enddo
         enddo
      enddo
      enddo


      return
      end

!=======================================================================
      subroutine interVel(v1,v2,v3,v4,px,py,v)
!=======================================================================
      implicit none
      real*8 v1,v2,v3,v4,px,py,v
      v=(1.d0-px)*((1.d0-py)*v1+py*v3)+px*((1.d0-py)*v2+py*v4)
      return
      end

