!=======================================================================
      subroutine ptprint(nx,ny,mptcl,nspcs,level,it,nt,ierr,
     &      ax,ay, ht,tn,hx,hy,NPT,ptcl,vel,xbar)
!=======================================================================
      implicit none
      integer nx,ny,mptcl,nspcs,level,it,nt,ierr
      real*8  ax,ay,ht,tn,hx,hy
      integer NPT(nx,ny)
      real*8  ptcl((2+nspcs),mptcl,nx,ny)
      real*8  vel(2,0:nx,0:ny),xbar(2,0:nx,0:ny)

!---- Local variables

      integer ix,iy,itloc
      real*8  x0,y0,trx,try,pi,distance,v0,vx,vy,gx,gy,tnloc

!---- Information interface

      if(level.ge.1) print'("PTPRINT: @tn=",f8.4)',tn
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
      endif

      pi=4.d0*datan(1.d0)
!-------------------------------------

      do iy=1,ny
      do ix=1,nx
         if(NPT(ix,iy).eq.1)then
            x0=ax+dble(ix-1)*hx+ptcl(1,1,ix,iy)*hx
            y0=ay+dble(iy-1)*hy+ptcl(2,1,ix,iy)*hy
            trx=dcos(2.d0*pi*tn)
            try=dsin(2.d0*pi*tn)
            distance=dsqrt((x0-trx)**2+(y0-try)**2)
            write(88,*) 360.d0*tn,distance
            goto 4444
         endif
      enddo
      enddo

!---- individual movement

 4444 if(it.ne.1) return

      open(unit=99,file="fort.99")
      open(unit=77,file="fort.77")

      write(99,*) 0.d0,0.d0
      write(77,*) 1.d0,0.d0

      x0=1.d0
      y0=0.d0

      do itloc=1,nt

         tnloc=ht*dble(itloc)

         ix=min(nx,int((x0-ax)/hx)+1)
         iy=min(ny,int((y0-ay)/hy)+1)

         gx=dble(ix-1)*hx+ax
         gy=dble(iy-1)*hy+ay
           if(gx.ge.x0)ix=ix-1
           if(gx.lt.(x0-hx))ix=ix+1
           if(gy.ge.y0)iy=iy-1
           if(gy.lt.(y0-hy))iy=iy+1
         gx=dble(ix-1)*hx+ax
         gy=dble(iy-1)*hy+ay

         v0=vel(1,ix-1,iy-1)
         vx=v0+(vel(1,ix,iy-1)-v0)*(x0-gx)/hx
         v0=vel(2,ix-1,iy-1)
         vy=v0+(vel(2,ix-1,iy)-v0)*(y0-gy)/hy

         x0=x0+vx*ht
         y0=y0+vy*ht

         trx=dcos(2.d0*pi*tnloc)
         try=dsin(2.d0*pi*tnloc)

         distance=dsqrt((x0-trx)**2+(y0-try)**2)
         write(99,*) 360.d0*tnloc,distance
         write(77,*) x0,y0

      enddo

      close(99)


      return
      end

