!=======================================================================
      subroutine pmm(nt,nx,ny,auto_dt,intpol1,intpol2,lastIntpol,
     &   nconv,ndiff,nreact,nbc,nvel,mptcl,iptcl,nspcs,
     &   id_initial,idualmesh,numerical,idsol,level,itmax,ierr,
     &   at,bt,ax,bx,ay,by,sigma,epsilon,tol,
     &   NPT,ptcl,con,vel,xbar,A3,A5,b,wksp)
!=======================================================================
      implicit none
      integer nt,nx,ny,auto_dt,intpol1,intpol2,lastIntpol
      integer nconv,ndiff,nreact,nbc,nvel,mptcl,iptcl,nspcs
      integer id_initial,idualmesh,numerical,idsol,level,itmax,ierr
      real*8  at,bt,ax,bx,ay,by,sigma,epsilon,tol
      integer NPT(nx*ny,2)
      real*8  ptcl((2+nspcs)*mptcl*nx*ny,2),con(nx,ny)
      real*8  vel(2,0:nx,0:ny),xbar(2,0:nx,0:ny)
      real*8  wksp(*)
      real*8  A3(3*nx*ny,2),A5(*),b(*)

!=======================================================================
! See also pmm.f
!-----------------------------------------------------------------------
! sigma     <=1: Courant number
! idualmesh ==0: Transport part: Euler or RK4
!           ==1: Transport part: Dual-Mesh Char. with "Euler \bar{x}"
!           ==2: Transport part: Dual-Mesh Char. with "Exact \bar{x}"
! idsol     ==1: Transport part: Euler method when idualmesh=0
!           ==4: Transport part: RK4 method when idualmesh=0
! nvel      ==1: Rotation
! id_initial==1: box initial
!           ==2: Pi-shape initial
! lastIntpol==1: Interpolation at the last moment
!=======================================================================

!---- local variables

      integer ix,iy,level0
      real*8  ht,hx,hy,cmax,totalmass
      real*4  utime0,stime0,utime1,stime1
      character*40 file

!---- Informing: stdout

      if(level.ge.1) print'("PMM: mptcl=",i2," iptcl=",i2)',mptcl,iptcl
      if(level.ge.2) then
         print*,"nt=",nt," at=",at," bt=",bt
         print*,"nx=",nx," ax=",ax," bx=",bx
         print*,"ny=",ny," ay=",ay," by=",by
         print*,"nconv=",nconv," ndiff=",ndiff," nreact=",nreact
         print*,"nbc=",nbc," intpol1=",intpol1," intpol2=",intpol2
     &         ," lastIntpol=",lastIntpol," id_initial=",id_initial
     &         ," idualmesh=",idualmesh," nvel=",nvel
         print*,"sigma=",sigma," epsilon=",epsilon," tol=",tol
      endif

      call etimef77(utime0,stime0)

!---------------------
!---- Set variables
!---------------------

*      level0=level
      level0=1

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)

!---------------------
!---- Set commons
!---------------------

      if(numerical.eq.1)then
         nconv=1
         ndiff=0
         nreact=0
         nbc=0
         intpol1=0
         intpol2=0
      endif

      call setcommons(nconv,ndiff,nreact,nbc,epsilon)

!----------------------------------------
!---- Get Velocity & (ht & nt) & xbar
!----------------------------------------

      call getvel(nx,ny,nvel,level0,hx,hy,at,ax,bx,ay,by,vel)

      if(auto_dt.eq.0) then
         ht=(bt-at)/dble(nt)
      else
        call getht(nt,nx,ny,nvel,level0,hx,hy,
     &             at,bt,ax,bx,ay,by,vel,sigma,ht)
        if(level.ge.1) print*,"Automatic: nt=",nt," ht=",ht
      endif

      call getxbar(nx,ny,idualmesh,level0,
     &             ht,hx,hy,at,ax,bx,ay,by,vel,xbar)


!----------------------------------------------------
!---- Initialization of Concentration and Particles
!----------------------------------------------------

      call initial(nx,ny,level0,nspcs,mptcl,iptcl,nvel,numerical,
     &             id_initial,nconv,hx,hy,at,ax,bx,ay,by,con,ptcl,NPT)


!---------------------
!---- Print "C0"
!---------------------

      if(level.ge.2) then
         open(1,file="fort.0")
         write(1,*) nt,at,ht
            close(1)
         open(1,file="fort.1")
         write(1,*) nx,ax,hx,ny,ay,hy
            close(1)
         open(1,file="fort.2")
         if(epsilon.eq.0.0)then
            write(1,'(f7.1,2x,f5.1,2x,i1)') bt,sigma,nint(epsilon)
         elseif(epsilon.ge.0.001)then
            write(1,'(f7.1,2x,f5.1,2x,f5.3)') bt,sigma,epsilon
         else
            write(1,'(f7.1,2x,f5.1,2x,1pe7.0)') bt,sigma,epsilon
         endif
            close(1)
         file="fort.C0"
         call fwrite(file,nx*ny,con,ierr)
      endif

!---------------------
!---- Time Marching
!---------------------

      call timemarch(nt,nx,ny,auto_dt,nconv,ndiff,nreact,nbc,nvel,
     &     intpol1,intpol2,lastIntpol,iptcl,mptcl,nspcs,
     &     idualmesh,numerical,idsol,level,itmax,ierr,
     &     ht,hx,hy,sigma,epsilon, at,bt,ax,bx,ay,by,tol,
     &     NPT,ptcl,con,vel,xbar,A3(1,1),A3(1,2),A5,b,wksp)

      if(level.ge.1)then
         call etimef77(utime1,stime1)
         print'("Elapsed Time=",f7.2,"u",f7.2,"s")',
     &              utime1-utime0,stime1-stime0
      endif

!---------------------
!---- Print "C1"
!---------------------

      if(level.ge.2) then

         cmax=0.d0
         totalmass=0.d0
         do iy=1,ny
         do ix=1,nx
             cmax=max(cmax,con(ix,iy))
             totalmass=totalmass+con(ix,iy)
         enddo
         enddo
         print*,"C_max=",cmax," totalmass=",totalmass

         file="fort.C1"
         call fwrite(file,nx*ny,con,ierr)

         if(nconv.eq.1 .and. ndiff.eq.1) then
            if(idualmesh.eq.1) then
               file="fort.111"
            elseif(idualmesh.eq.2) then
               file="fort.112"
            elseif(idsol.eq.1) then
               file="fort.1101"
            elseif(idsol.eq.4) then
               file="fort.1104"
            endif
         else if(nconv.eq.0 .and. ndiff.eq.1) then
            file="fort.01"
         else if(nconv.eq.1 .and. ndiff.eq.0) then
            file="fort.10"
         endif

         call fwrite2(file,ax,bx,nx,con(1,(ny/2)),ierr)
      endif

      return
      end
