c=======================================================================
      real*8 function b1(x,y)
c=======================================================================
      implicit none
      include 'commons.h'
      real*8 x,y

      if(ndiff.le.0)then
          b1=0.d0
      elseif (ndiff.le.1) then
          b1=epsilon
      else if(ndiff.eq.2)then
          b1=1.0d0
      else if(ndiff.eq.3)then
          if(x.le.0.5001)then
            b1=1.d0+0.5*dsin(5.d0*pi*x)+y**3
          else
            b1=1.5d0/(1.d0+(x-0.5d0)**2)+y**3
          endif
      else if(ndiff.eq.4)then
          b1=1.d0/(2.d0+dcos(3.d0*pi*x)*dcos(2.d0*pi*y))
      else
        stop 'Do definition for ndiff'
      endif

      return
      end

c=======================================================================
      real*8 function b2(x,y)
c=======================================================================
      implicit none
      include 'commons.h'
      real*8 x,y

      if(ndiff.le.0)then
          b2=0.d0
      elseif(ndiff.le.1) then
          b2=epsilon
      elseif(ndiff.eq.2)then
          b2=2.0d0
      elseif(ndiff.eq.3 .or. ndiff.eq.4)then
          if(x.le.0.5001)then
            b2=1.d0+0.5*dsin(5.d0*pi*x)+y**3
          else
            b2=1.5d0/(1.d0+(x-0.5d0)**2)+y**3
          endif
      endif

      return
      end

