!=======================================================================
      subroutine initial(nx,ny,level,nspcs,mptcl,iptcl,nvel,numerical,
     &            id_initial,nconv,hx,hy,at,ax,bx,ay,by,con,ptcl,NPT)
!=======================================================================
      implicit none
      integer nx,ny,level,nspcs,mptcl,iptcl,nvel,numerical
      integer id_initial,nconv
      real*8  hx,hy,at,ax,bx,ay,by
      real*8  con(nx,ny),ptcl((2+nspcs),mptcl,nx,ny)
      integer NPT(nx,ny)

      integer k,ix,iy,ip,is,nx1,ny1,nx2,ny2,margin
      real*8  sx,sy,px,py,zero

      if(level.ge.1) print'("INITIAL: @t=",f7.3," nvel=",i1)',at,nvel
      if(level.ge.2) then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"mptcl=",mptcl," iptcl=",iptcl," nspcs=",nspcs
      endif
      if(iptcl.gt.mptcl) stop 'initial.f: iptcl.gt.mptcl'

      zero=0.d0

!------------------------------
!---- Initial setting
!------------------------------

      do iy=1,ny
      do ix=1,nx
         con(ix,iy)=zero
      enddo
      enddo

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy)=0
      enddo
      enddo

!------------------------------
!---- for numerical test
!------------------------------

      if(numerical.eq.1)then
         ix=nint((1.d0-ax)/hx)
         iy=nint((0.d0-ay)/hy)
         NPT(ix,iy)=1
         ptcl(1,1,ix,iy)=1.d0
         ptcl(2,1,ix,iy)=1.d0
         ptcl(3,1,ix,iy)=1.d0
         con(ix,iy)=1.d0
         return
      endif

!-----------------------------------
!---- Concentration Initialization
!-----------------------------------

      if(id_initial.le.0 .or. id_initial.ge.3)then
         stop 'initial.d: id_initial is wrong'
      endif

      goto(100,200),id_initial

 100  continue

      if(nvel.eq.1)then
         sx=1.0d0
         sy=0.0d0
      elseif(nvel.eq.2)then
         if(nconv.eq.1)then
            sx=-1.d0
            sy=-1.d0
         else
            sx=1.d0
            sy=1.d0
         endif
      elseif(nvel.eq.3)then
         if(nconv.eq.1)then
            sx=-2.d0
            sy= 0.d0
         else
            sx= 1.d0
            sy= 0.d0
         endif
      elseif(nvel.ge.4)then
         if(nconv.eq.1)then
            sx=-1.d0
            sy= 0.d0
         else
            sx= 1.d0
            sy= 0.d0
         endif
      endif

      margin=nint(0.5d0/hx)
      nx1=max(1,nint((sx-ax)/hx))
      ny1=max(1,nint((sy-ay)/hy))

      if(level.ge.1) then
         print*,"initial.f: idpoint=1"
         print*,"nx1,nx1*hx+ax=",nx1,nx1*hx+ax
         print*,"ny1,ny1*hy+ay=",ny1,ny1*hy+ay
      endif

      do iy=ny1-(margin-1),ny1+margin+1
      do ix=nx1-(margin-1),nx1+margin+1
         con(ix,iy)=1.0d0
         do is=1,nspcs
            ptcl(2+is,1,ix,iy)=con(ix,iy)
         enddo
      enddo
      enddo
      goto 1000


 200  continue

      if(level.ge.1)then
         print*
         print*,"PiPiPiPiPiPiPiPiPiPiPiPi"
         print*,"PiPiPiPiPiPiPiPiPiPiPiPi"
         do ix=1,6
             print*,"    PiPiPi    PiPiPi"
         enddo
         print*
      endif

      margin=6
      do k=1,3
          if(k.eq.1)then
              !-- Horizontal bar
              nx1=(nx*4)/6-margin
              nx2=(nx*5)/6+margin
              ny2=(ny*4)/6
              ny1=ny2-margin
          elseif(k.eq.2)then
              !-- the first vertical
              nx1=(nx*4)/6-margin/2
              nx2=nx1+margin
              ny1=(ny*2)/6
              ny2=(ny*4)/6
          elseif(k.eq.3)then
              !-- the second vertical
              nx1=(nx*5)/6-margin/2
              nx2=nx1+margin
              ny1=(ny*2)/6
              ny2=(ny*4)/6
          endif

          do iy=ny1,ny2
          do ix=nx1,nx2
             con(ix,iy)=1.0d0
             do is=1,nspcs
                ptcl(2+is,1,ix,iy)=con(ix,iy)
             enddo
          enddo
          enddo

      enddo


!------------------------------------------------------------------
!---- Particles: save relative positions; see "xbar" in "getxbar.f"
!------------------------------------------------------------------

 1000 continue

      if(iptcl.eq.1) then

         do iy=1,ny
         do ix=1,nx
*            if(con(ix,iy).ne.zero) then   !!
               NPT(ix,iy)=iptcl
               ptcl(1,1,ix,iy)=0.5d0
               ptcl(2,1,ix,iy)=0.5d0
               do is=1,nspcs
               ptcl(2+is,1,ix,iy)=con(ix,iy)
               enddo
*            endif                         !!
         enddo
         enddo

      else if(iptcl.eq.4) then

         do iy=1,ny
         do ix=1,nx
*            if(con(ix,iy).ne.zero) then   !!
               NPT(ix,iy)=iptcl
               py=0.25d0
               do ip=1,iptcl
                  if(ip.eq.1.or.ip.eq.3)then
                     px=0.25d0
                  else
                     px=0.75d0
                  endif
                  if(ip.eq.3)py=0.75d0
                  ptcl(1,ip,ix,iy)=px
                  ptcl(2,ip,ix,iy)=py
                  do is=1,nspcs
                  ptcl(2+is,ip,ix,iy)=con(ix,iy)*0.25d0
                  enddo
               enddo
*            endif                         !!
         enddo
         enddo

      else
         stop 'INITIAL.F: iptcl is 1 or 4'
      endif

      return
      end

