!=======================================================================
      subroutine getxbar(nx,ny,idualmesh,level,
     &                   ht,hx,hy,at,ax,bx,ay,by,vel,xbar)
!=======================================================================
!---- "xbar" saves the relative difference: -\bar{v}*ht/h
!---- See "ptcl" to be intialized in "initial.f"
      implicit none
      integer nx,ny,idualmesh,level
      real*8  ht,hx,hy,at,ax,bx,ay,by
      real*8  vel(2,0:nx,0:ny),xbar(2,0:nx,0:ny)

      integer ix,iy
      real*8  v,a,rhx,rhy,eps,zero,sx,sy

      if(idualmesh.lt.1 .or. idualmesh.gt.2) return

      if(level.ge.1) print'("GETXBAR: @t=",f7.3)',at
      if(level.ge.1) then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"idualmesh=",idualmesh
      endif

      rhx=1.d0/hx
      rhy=1.d0/hy
      eps=1.d-10
      zero=0.d0

      sx=1.d0/hx     ! scaling factors
      sy=1.d0/hy


      goto (10,20), idualmesh

 10    continue
!---- The Euler method for the final value problem
!---- in the Dual-Mesh movement

      print*,"**** Euler method is used for Dual-Mesh movement. ****"
      print*,"**** For the exact formula, set idualmesh=2.      ****"

      do iy=0,ny
      do ix=0,nx
        xbar(1,ix,iy)=-vel(1,ix,iy)*ht*sx
        xbar(2,ix,iy)=-vel(2,ix,iy)*ht*sy
      enddo
      enddo
      return


 20    continue
!---- The Exact solver for the final value problem
!---- in the Dual-Mesh movement

      do iy=0,ny
      do ix=0,nx

         v=vel(1,ix,iy)
         if(v.ge.zero)then
            if(ix.eq.0) then
               a=zero
            else
               a=(v-vel(1,ix-1,iy))*rhx
            endif
         else
            if(ix.eq.nx) then
               a=zero
            else
               a=(vel(1,ix+1,iy)-v)*rhx
            endif
         endif
         if(dabs(a).lt.eps)then
            xbar(1,ix,iy)=-v*ht
         else
            xbar(1,ix,iy)=-(1.d0-dexp(-a*ht))*v/a
         endif

         v=vel(2,ix,iy)
         if(v.ge.zero)then
            if(iy.eq.0) then
               a=zero
            else
               a=(v-vel(2,ix,iy-1))*rhy
            endif
         else
            if(iy.eq.ny) then
               a=zero
            else
               a=(vel(2,ix,iy+1)-v)*rhy
            endif
         endif
         if(dabs(a).lt.eps)then
            xbar(2,ix,iy)=-v*ht
         else
            xbar(2,ix,iy)=-(1.d0-dexp(-a*ht))*v/a
         endif

         !---- scaling

         xbar(1,ix,iy)=xbar(1,ix,iy)*sx
         xbar(2,ix,iy)=xbar(2,ix,iy)*sy

      enddo
      enddo

      return
      end

