!=======================================================================
      subroutine getht(nt,nx,ny,nvel,level,hx,hy,
     &                 at,bt,ax,bx,ay,by,vel,sigma,ht)
!=======================================================================
      implicit none
      integer nt,nx,ny,nvel,level
      real*8  hx,hy,at,bt,ax,bx,ay,by
      real*8  vel(2,0:nx,0:ny),sigma,ht
      real*8  freq
      common /t2freq/freq

      integer ix,iy
      real*8  vxmax,vymax,pi

      if(level.ge.1) print'("GETHT: @t=",f7.3)',at
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
         print*,"ax=",ax," bx=",bx
         print*,"ay=",ay," by=",by
         print*,"hx=",hx," hy=",hy
      endif

      vxmax=0.d0
      vymax=0.d0

      if(nvel.eq.4)then

         pi=4.d0*datan(1.d0)
         vxmax=2.d0
         vxmax=2.d0*freq*pi

      else

         do iy=0,ny
         do ix=0,nx
            vxmax=max(vxmax,dabs(vel(1,ix,iy)))
            vymax=max(vymax,dabs(vel(2,ix,iy)))
         enddo
         enddo

      endif

      ht=sigma*min(hx/vxmax,hy/vymax)

      nt=int((bt-at)/ht)+1
      ht=(bt-at)/dble(nt)

      return
      end

