!=======================================================================
      subroutine evalCell(imode,nx,ny,iptcl,mptcl,nspcs,idspcs,level,
     &     intpol1,intpol2,ierr,tn,NPT,ptcl,con)
!=======================================================================
      implicit none
      integer imode,nx,ny,iptcl,mptcl,nspcs,idspcs,level
      integer intpol1,intpol2,ierr
      real*8  tn
      integer NPT(nx,ny)
      real*8  ptcl((2+nspcs),mptcl,nx,ny),con(nx,ny)

!---- if(imode.eq.1): evaluate Cell-value from Particles
!---- if(imode.eq.2): evaluate Particles from Cell-value

!---- local variables

      integer ix,iy,ip,is,ipmax,idspcs2,nxm1,nym1,count
      real*8  value,c0,scale,zero,px,py,dx,dy,half,one,s1,s2

!---- Informing: stdout

      if(level.ge.1) print'("EVALCELL: @tn=",f10.5)',tn
      if(level.ge.2) then
         print*,"imode=",imode," nx=",nx," ny=",ny
      endif

      idspcs2=idspcs+2
      zero=0.d0
      nxm1=nx-1
      nym1=ny-1

!----------------------------
      goto(10,20),imode
!----------------------------

 10   continue
!---- evaluation of "Cell-value"

      if(intpol1.eq.0)then

         do iy=1,ny
         do ix=1,nx
            c0=zero
            ipmax=NPT(ix,iy)
            do ip=1,ipmax
               c0=c0+ptcl(idspcs2,ip,ix,iy)
            enddo
            con(ix,iy)=c0
         enddo
         enddo

      elseif(intpol1.eq.1)then

         half=0.5d0
         one =1.0d0

         do iy=1,ny
         do ix=1,nx
            con(ix,iy)=zero
         enddo
         enddo

         do iy=1,ny
         do ix=1,nx
            ipmax=NPT(ix,iy)
            do ip=1,ipmax
               px=ptcl(1,ip,ix,iy)
               py=ptcl(2,ip,ix,iy)
               c0=ptcl(idspcs2,ip,ix,iy)
              if(py.lt.half)then
                 dy=half+py
                 if(px.lt.half)then
                   dx=half+px
                   con(ix,iy)=con(ix,iy)+dx*dy*c0
                   if(ix.ne.1 )con(ix-1,iy)=con(ix-1,iy)+(one-dx)*dy*c0
                   if(iy.ne.1 )con(ix,iy-1)=con(ix,iy-1)+dx*(one-dy)*c0
                   if(ix.ne.1.and.iy.ne.1) then
                     con(ix-1,iy-1)=con(ix-1,iy-1)+(one-dx)*(one-dy)*c0
                   endif
                 else
                   dx=1.5d0-px
                   con(ix,iy)=con(ix,iy)+dx*dy*c0
                   if(ix.ne.nx)con(ix+1,iy)=con(ix+1,iy)+(one-dx)*dy*c0
                   if(iy.ne.1 )con(ix,iy-1)=con(ix,iy-1)+dx*(one-dy)*c0
                   if(ix.ne.nx.and.iy.ne.1) then
                     con(ix+1,iy-1)=con(ix+1,iy-1)+(one-dx)*(one-dy)*c0
                   endif
                 endif
              else
                 dy=1.5d0-py
                 if(px.lt.half)then
                   dx=half+px
                   con(ix,iy)=con(ix,iy)+dx*dy*c0
                   if(ix.ne.1 )con(ix-1,iy)=con(ix-1,iy)+(one-dx)*dy*c0
                   if(iy.ne.ny)con(ix,iy+1)=con(ix,iy+1)+dx*(one-dy)*c0
                   if(ix.ne.1.and.iy.ne.ny) then
                     con(ix-1,iy+1)=con(ix-1,iy+1)+(one-dx)*(one-dy)*c0
                   endif
                 else
                   dx=1.5d0-px
                   con(ix,iy)=con(ix,iy)+dx*dy*c0
                   if(ix.ne.nx)con(ix+1,iy)=con(ix+1,iy)+(one-dx)*dy*c0
                   if(iy.ne.ny)con(ix,iy+1)=con(ix,iy+1)+dx*(one-dy)*c0
                   if(ix.ne.nx.and.iy.ne.ny) then
                     con(ix+1,iy+1)=con(ix+1,iy+1)+(one-dx)*(one-dy)*c0
                   endif
                 endif
              endif
            enddo
         enddo
         enddo

      endif

      return


 20   continue
!---- Apportionment: evaluation of "Particle-values"

      do iy=1,ny
      do ix=1,nx

         c0=max(zero,con(ix,iy))
         ipmax=NPT(ix,iy)

         if(ipmax.eq.0)then             !---- new particles

            if(c0.gt.zero)then
               NPT(ix,iy)=iptcl
               do ip=1,iptcl
               do is=1,nspcs
                  ptcl(2+is,ip,ix,iy)=zero
               enddo
               enddo
               if(iptcl.eq.1)then
                  ptcl(1,1,ix,iy)=0.5d0
                  ptcl(2,1,ix,iy)=0.5d0
                  ptcl(idspcs2,1,ix,iy)=c0
               elseif(iptcl.eq.4)then
                  py=0.25d0
                  do ip=1,iptcl
                     if(ip.eq.1.or.ip.eq.3)then
                        px=0.25d0
                     else
                        px=0.75d0
                     endif
                     if(ip.eq.3)py=0.75d0
                     ptcl(1,ip,ix,iy)=px
                     ptcl(2,ip,ix,iy)=py
                     do is=1,nspcs
                     ptcl(2+is,ip,ix,iy)=c0*0.25d0
                     enddo
                  enddo
               else
                  stop 'evalCell.f: iptcl should be 1 or 4'
               endif
            endif

         else                           !---- Value adjustment

            value=0.0d0
            do ip=1,ipmax
               value=value+ptcl(idspcs2,ip,ix,iy)
            enddo

            if(c0.lt.value)then
               scale=c0/value
               do ip=1,ipmax
                  ptcl(idspcs2,ip,ix,iy)=ptcl(idspcs2,ip,ix,iy)*scale
               enddo
            else if(c0.gt.value)then
               scale=(c0-value)/dble(ipmax)
               do ip=1,ipmax
                  ptcl(idspcs2,ip,ix,iy)=ptcl(idspcs2,ip,ix,iy)+scale
               enddo
            endif

            !---- post interpolation

            if(intpol2.eq.2)then
               scale=c0/dble(ipmax)
               do ip=1,ipmax
                  ptcl(idspcs2,ip,ix,iy)=0.5d0*ptcl(idspcs2,ip,ix,iy)
     &                                  +0.5d0*scale
               enddo
            elseif(intpol2.eq.3)then
               scale=c0/dble(ipmax)
               do ip=1,ipmax
                  ptcl(idspcs2,ip,ix,iy)=scale
               enddo
            endif

         endif

      enddo
      enddo


!---- Basic smoothing, if (intpol2.eq.1):
!---- Below, "s1" is the scaling factor for the difference between
!---- the maximum and minimum of particle values in a cell.

      if(imode.eq.1 .or. intpol2.ne.1)return

      do 2000 iy=2,nym1
      do 1000 ix=2,nxm1

         c0=con(ix,iy)

         count=0
         if(c0.gt.con(ix,iy-1)) count=count+1
         if(c0.gt.con(ix-1,iy)) count=count+1
         if(c0.gt.con(ix+1,iy)) count=count+1
         if(c0.gt.con(ix,iy+1)) count=count+1

         if(count.le.1) then
            goto 1000
         elseif(count.eq.2)then
            s1=0.95d0
         elseif(count.eq.3)then
            s1=0.85d0
         else
            s1=0.75d0
         endif

         s2=1.d0-s1
         ipmax=NPT(ix,iy)
         scale=c0/dble(ipmax)

         do ip=1,ipmax
            ptcl(idspcs2,ip,ix,iy)=s1*ptcl(idspcs2,ip,ix,iy)
     &                            +s2*scale
         enddo

 1000 continue
 2000 continue


      return
      end
