!=======================================================================
      subroutine euler(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &      NPT,ptcl,vel)
!=======================================================================
      implicit none
      integer nx,ny,mptcl,nspcs,level,ierr
      real*8  ht,tn,hx,hy
      integer NPT(nx,ny,2)
      real*8  ptcl((2+nspcs),mptcl,nx,ny,2),vel(2,0:nx,0:ny)

!---- Local variables

      integer ix,iy,is,ip,nspcs2
      integer ixn,iyn,ipn,id1,id2
      real*8  vx,vy,vx1,vx2,vx3,vx4,vy1,vy2,vy3,vy4
      real*8  px,py,zero,one

!---- Information interface

      if(level.ge.1) print'("EULER: @tn=",f8.4)',tn
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
         print*,"mptcl=",mptcl," nspcs=",nspcs
      endif

!---- Local setting

      nspcs2=nspcs+2

      zero=0.d0
      one =1.d0

!-------------------------------------
!---- Individual Moving of Particles
!-------------------------------------

      id1=1
      id2=2

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy,id2)=0
      enddo
      enddo

!----------------
      do iy=1,ny
      do ix=1,nx

         vx1=vel(1,ix-1,iy-1)
         vy1=vel(2,ix-1,iy-1)
         vx2=vel(1,ix,iy-1)
         vy2=vel(2,ix,iy-1)
         vx3=vel(1,ix-1,iy)
         vy3=vel(2,ix-1,iy)
         vx4=vel(1,ix,iy)
         vy4=vel(2,ix,iy)

      do 1000 ip=1,NPT(ix,iy,id1)

         iyn=iy
         ixn=ix

         px=ptcl(1,ip,ix,iy,id1)
         py=ptcl(2,ip,ix,iy,id1)
         vx=(one-px)*((one-py)*vx1+py*vx3)+px*((one-py)*vx2+py*vx4)
         vy=(one-px)*((one-py)*vy1+py*vy3)+px*((one-py)*vy2+py*vy4)

         px=px+vx*ht/hx
         py=py+vy*ht/hy

         if(px.gt.one) then
            ixn=ix+1
            px=px-one
         elseif(px.lt.zero) then
            ixn=ix-1
            px=px+one
         endif
         if(ixn.lt.1 .or. ixn.gt.nx)goto 1000

         if(py.gt.one) then
            iyn=iy+1
            py=py-one
         elseif(py.lt.zero) then
            iyn=iy-1
            py=py+one
         endif
         if(iyn.lt.1 .or. iyn.gt.ny)goto 1000

         ipn=NPT(ixn,iyn,id2)+1
         NPT(ixn,iyn,id2)=ipn
         if(ipn.gt.mptcl) stop 'individual.f: mptcl is not enough.'

         ptcl(1,ipn,ixn,iyn,id2)=px
         ptcl(2,ipn,ixn,iyn,id2)=py
         do is=1,nspcs
            ptcl(2+is,ipn,ixn,iyn,id2)=ptcl(2+is,ip,ix,iy,id1)
         enddo

 1000 continue

      enddo
      enddo


!-------------------------------------
!---- Copy Back
!-------------------------------------

      id1=2
      id2=1

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy,id2)=NPT(ix,iy,id1)
         do ip=1,NPT(ix,iy,id2)
         do is=1,nspcs2
            ptcl(is,ip,ix,iy,id2)=ptcl(is,ip,ix,iy,id1)
         enddo
         enddo
      enddo
      enddo


      return
      end

