!=======================================================================
      subroutine dualmesh(nx,ny,mptcl,nspcs,level,ierr, ht,tn,hx,hy,
     &      NPT,ptcl,xbar)
!=======================================================================
      implicit none
      integer nx,ny,mptcl,nspcs,level,ierr
      real*8  ht,tn,hx,hy
      integer NPT(nx,ny,2)
      real*8  ptcl((2+nspcs),mptcl,nx,ny,2),xbar(2,0:nx,0:ny)

!---- Local variables

      integer ix,iy,is,ip,im
      integer ixn,iyn,ipn,ipmax,id1,id2
      integer nxm1,nym1,ixm1,iym1
      real*8  x0,y0,b1x0,b1y0,a0,a1,zero,one,two

!---- Information interface

      if(level.ge.1) print'("DUALMESH: @tn=",f8.4)',tn
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
      endif

!---- Local setting

      nxm1=nx-1
      nym1=ny-1

      zero=0.d0
      one =1.d0
      two =2.d0


!-------------------------------------
!---- X-Directional Moving
!-------------------------------------

      id1=1
      id2=2

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy,id2)=0
      enddo
      enddo

!----------------
      do iy=1,ny
         iym1=iy-1
      do ix=1,nx
         ixm1=ix-1
         ipmax=NPT(ix,iy,id1)

      do 1000 ip=1,ipmax
         x0=ptcl(1,ip,ix,iy,id1)
         y0=ptcl(2,ip,ix,iy,id1)
         b1y0=one-y0
         a0=y0*xbar(id1,ixm1,iy)+b1y0*xbar(id1,ixm1,iym1)
         if(a0.ge.x0)then
            if(ix.eq.1) goto 1000
            im=-1          ! move to Left cell
            a1=a0
            a0=y0*xbar(id1,ix-2,iy)+b1y0*xbar(id1,ix-2,iym1)-one
         else
            a1=y0*xbar(id1,ix,iy)+b1y0*xbar(id1,ix,iym1)+one
            if(a1.ge.x0)then
               im=0        ! stay in the same cell
            else
               if(ix.eq.nx) goto 1000
               im=1        ! move to Right cell
               a0=a1
               a1=y0*xbar(id1,ix+1,iy)+b1y0*xbar(id1,ix+1,iym1)+two
            endif
         endif

         x0=(x0-a0)/(a1-a0)

         ixn=ix+im
         ipn=NPT(ixn,iy,id2)+1
         if(ipn.gt.mptcl) stop 'transport.f: mptcl is not enough'
         NPT(ixn,iy,id2)=ipn

         ptcl(1,ipn,ixn,iy,id2)=x0
         ptcl(2,ipn,ixn,iy,id2)=y0
         do is=1,nspcs
            ptcl(2+is,ipn,ixn,iy,id2)=ptcl(2+is,ip,ix,iy,id1)
         enddo

 1000 continue

      enddo
      enddo

!-------------------------------------
!---- Y-Directional Moving
!-------------------------------------

      id1=2
      id2=1

      do iy=1,ny
      do ix=1,nx
         NPT(ix,iy,id2)=0
      enddo
      enddo

!----------------
      do iy=1,ny
         iym1=iy-1
      do ix=1,nx
         ixm1=ix-1
         ipmax=NPT(ix,iy,id1)

      do 2000 ip=1,ipmax
         x0=ptcl(1,ip,ix,iy,id1)
         y0=ptcl(2,ip,ix,iy,id1)
         b1x0=one-x0
         a0=x0*xbar(id1,ix,iym1)+b1x0*xbar(id1,ixm1,iym1)
         if(a0.ge.y0)then
            if(iy.eq.1) goto 2000
            im=-1          ! move to South cell
            a1=a0
            a0=x0*xbar(id1,ix,iy-2)+b1x0*xbar(id1,ixm1,iy-2)-one
         else
            a1=x0*xbar(id1,ix,iy)+b1x0*xbar(id1,ixm1,iy)+one
            if(a1.ge.y0)then
               im=0        ! stay in the same cell
            else
               if(iy.eq.ny) goto 2000
               im=1        ! move to North cell
               a0=a1
               a1=x0*xbar(id1,ix,iy+1)+b1x0*xbar(id1,ixm1,iy+1)+two
            endif
         endif

         y0=(y0-a0)/(a1-a0)

         iyn=iy+im
         ipn=NPT(ix,iyn,id2)+1
         if(ipn.gt.mptcl) stop 'transport.f: mptcl is not enough'
         NPT(ix,iyn,id2)=ipn

         ptcl(1,ipn,ix,iyn,id2)=x0
         ptcl(2,ipn,ix,iyn,id2)=y0
         do is=1,nspcs
            ptcl(2+is,ipn,ix,iyn,id2)=ptcl(2+is,ip,ix,iy,id1)
         enddo

 2000 continue

      enddo
      enddo



      return
      end

