!=======================================================================
      subroutine diffusion(nx,ny,iptcl,mptcl,nspcs,level,itmax,iterPCG,
     &  nt,it,intpol1,intpol2,ierr, hx,hy,ht,sigma,epsilon,
     &  tol,tn, NPT,ptcl,con,A,AILU,b,wksp)
!=======================================================================
      implicit none
      integer nx,ny,iptcl,mptcl,nspcs,level,itmax,iterPCG
      integer nt,it,intpol1,intpol2,ierr
      real*8  hx,hy,ht,sigma,epsilon,tol,tn
      integer NPT(nx,ny)
      real*8  ptcl((2+nspcs),mptcl,nx,ny),con(nx,ny)
      real*8  A(5,nx,ny),AILU(5,nx,ny),b(nx,ny),wksp(*)

!---- local variables

      integer ix,iy,is,idpcond,level0,nsmooth
      real*8  alpha

!---- Infromation interface

      if(level.ge.1) print'("DIFFUSION: @t=",f7.3)',tn
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
      endif

      idpcond=1
      level0=0

!---- find the number of smoothing steps

*      alpha=sigma*ht/dsqrt(hx**2+hy**2)
*      nsmooth=int((alpha/(1.d0+alpha))*2.d0*dble(nt))+1
*      nsmooth=nt-nsmooth
*      nsmooth=nt+1-max(2,nt/50)

      nsmooth=nt-2
      if(it.eq.nsmooth)intpol2=max(2,intpol2)

!-------------------------------------------------
      do is=1,nspcs
!-------------------------------------------------

!---- Evaluate Cell-values

      call evalCell(1,nx,ny,iptcl,mptcl,nspcs,is,level0,
     &     intpol1,intpol2,ierr, tn,NPT,ptcl,con)

!---- Solve Diffusion operator

      do iy=1,ny
      do ix=1,nx
         b(ix,iy)=con(ix,iy)
      enddo
      enddo

      call pcg_ilu0c(nx,ny,itmax,idpcond,level0,iterPCG,
     &        A,AILU,con,b,wksp,tol,ierr)

!---- Return back to Particle values

      call evalCell(2,nx,ny,iptcl,mptcl,nspcs,is,level0,
     &     intpol1,intpol2,ierr, tn,NPT,ptcl,con)

!-------------------------------------------------
      enddo
!-------------------------------------------------

      return
      end

