#include "H1.h"

void setNoise(nx,ny,neqn,MZ_Noise,Impulse,level,ierr,MaxIm,U,wksp)

    ITYPE nx,ny,neqn,MZ_Noise,Impulse,level,*ierr;
    VTYPE MaxIm;
    ATYPE U[],wksp[][neqn];

{
    ITYPE i,i0,i1,nn;
    VTYPE xi,jump,rneqn,mean,var,SD,Add_MZ_Noise,sigma_sq,SNR;

    if(level>=1)
        printf("SET_NOISE: MZ_Noise=%d Impulse=%d\n",MZ_Noise,Impulse);

    randomNoise(nx,ny,level,MaxIm,wksp[0]);

    jump=100./Impulse;
    i0=0;
    xi=0.;
    rneqn=(VTYPE)neqn;


    /*----------------------*/
    /* Addtive Error, First */
    /*----------------------*/

    if(MZ_Noise>0){
        Add_MZ_Noise=0.01*MZ_Noise;

        mean=var=0.;
        for(i=0;i<neqn;i++)
            mean+=wksp[0][i];
        mean/=neqn;
        for(i=0;i<neqn;i++)
            var+=(mean-wksp[0][i])*(mean-wksp[0][i]);
        var/=neqn;
        SD=sqrt(var);
        sigma_sq=var*(Add_MZ_Noise*Add_MZ_Noise);

        for(i=0;i<neqn;i++)
            wksp[1][i]=Add_MZ_Noise*(wksp[0][i]-mean);

        getSNR(nx,ny,level,ierr,&SNR,U,wksp[1]);

        for(i=0;i<neqn;i++)
            U[i]+=wksp[1][i];

        if(level>0)
           printf(" Additive Noise: sigma_sq=%g SNR=%g\n",sigma_sq,SNR);
    }


    /*-----------------------------*/
    /* Now, Cell-Value Replacement */
    /*-----------------------------*/

    if(Impulse==5 || Impulse==10 || Impulse==15 || Impulse==20
                  || Impulse==25 || Impulse==33 || Impulse==50){
        if(Impulse==5)  nn=20;
        if(Impulse==10) nn=10;
        if(Impulse==15) nn=7;
        if(Impulse==20) nn=5;
        if(Impulse==25) nn=4;
        if(Impulse==33) nn=3;
        if(Impulse==50) nn=2;
        while(i0<neqn){
            i1=(int)(wksp[0][i0]*nn);
            for(i=0;i<nn;i++)
                if(i==i1 && (i0+i)<neqn)
                    U[i0+i]=wksp[0][i0+i];
            i0+=nn;
        }
    }
    else if(Impulse==67 || Impulse==75 || Impulse==80
                        || Impulse==90 || Impulse==95){
        if(Impulse==67) nn=3;
        if(Impulse==75) nn=4;
        if(Impulse==80) nn=5;
        if(Impulse==90) nn=10;
        if(Impulse==95) nn=20;
        while(i0<neqn){
            i1=(int)(wksp[0][i0]*nn);
            for(i=0;i<nn;i++)
                if(i!=i1 && (i0+i)<neqn)
                    U[i0+i]=wksp[0][i0+i];
            i0+=nn;
        }
    }
    else if(Impulse==100)
        for(i=0;i<neqn;i++)
            U[i]+=(wksp[0][i]-0.5);
    else if(Impulse!=0)
        while(xi<rneqn){
            i0=(int)xi;
            if(i0<neqn){
                i1=(int)(wksp[0][i0]*jump);
                if((i0+i1)<neqn)
                    U[i0+i1]=wksp[0][i0+i1];
            }
           xi+=jump;
        }

}

