#include "H1.h"

void getSigma(nx,ny,level,ierr,sigma_sq,U0,wksp)

    ITYPE nx,ny,level,*ierr;
    VTYPE *sigma_sq;
    ATYPE U0[][nx],wksp[][ny][nx];

{
    ITYPE i,j,iR,itMax,level0=0;
    VTYPE epsilon,tol,var;


    if(level>=1) printf("getSigma: nx=%d ny=%d\n", nx,ny);

    itMax=10;
    epsilon=0.01;
    tol=0.1;


    /****************/
    /* Get sigma_sq */
    /****************/

    for(j=0;j<ny;j++)
    for(i=0;i<nx;i++)
        wksp[0][j][i]=U0[j][i];

    getITV(nx,ny,itMax,&iR,level0,ierr,epsilon,tol,wksp[0],wksp[2]);

    if(level>=3)
    save2file("fort.ITV",1,nx,ny,1,1,1,ierr,wksp[iR],wksp[2]);

    var=0.0;
    for(j=0;j<ny;j++)
    for(i=0;i<nx;i++)
        var+=pow((U0[j][i]-wksp[iR][j][i]),2);

    *sigma_sq=var/(nx*ny);

    if(level>=1) printf(" Estimated sigma_sq=%g\n", *sigma_sq);

}

