#include "H1.h"

void getS(nx,ny,nD2,nRho,iScale,level,ierr,zeta,U,D,P,S)

    ITYPE nx,ny,nD2,nRho,iScale,level,*ierr;
    VTYPE zeta;
    ATYPE U[][nx],D[][ny][nx],P[][ny][nx],S[][nx];

{
    ITYPE i,j;
    ITYPE nxm1,nym1,im1,im2,ip1,ip2,jm1,jm2,jp1,jp2;
    VTYPE PW,PE,PS,PN,PC;
    VTYPE QW,QE,QS,QN,QC;
    ITYPE im,ip,jm,jp;
    VTYPE aW,aE,aS,aN,fac,z2;


    if(level>=1)
         printf(" getS: nx=%d ny=%d nD2=%d nRho=%d iScale=%d\n",
                  nx,ny,nD2,nRho,iScale);


    /*************************/
    /* Initial Check/Setting */
    /*************************/

    if(nRho<1 || nRho>3){
        printf("Error: getS.c: nRho=%d\n",nRho); *ierr=1; return; }

    nxm1=nx-1;
    nym1=ny-1;


    /*********/
    /* Get S */
    /*********/

   /*-----------------*/
    if(nD2==0){
   /*-----------------*/

        for(j=0;j<ny;j++){
            jm=max(j-1,0); jp=min(j+1,nym1);
        for(i=0;i<nx;i++){
            im=max(i-1,0); ip=min(i+1,nxm1);
            fac=2.0/(D[0][j][im]+D[0][j][i]);
            aW=D[0][j][i] *fac;
            aE=D[0][j][im]*fac;
            fac=2.0/(D[1][jm][i]+D[1][j][i]);
            aS=D[1][j][i] *fac;
            aN=D[1][jm][i]*fac;
            S[j][i]=4.*U[j][i]
                   -(aW*U[j][im]+aE*U[j][ip]+aS*U[jm][i]+aN*U[jp][i]);
        } }

   /*-----------------*/
    }else if(nD2==1){
   /*-----------------*/

        for(j=0;j<ny;j++){
            jm1=max(j-1,0); jp1=min(j+1,nym1);
        for(i=0;i<nx;i++){
            im1=max(i-1,0); ip1=min(i+1,nxm1);
            S[j][i]=(D[0][j][im1]+D[1][j][im1])/P[0][j][im1]
                   +(D[0][j][ip1]+D[1][j][ip1])/P[0][j][ip1]
                   +(D[0][jm1][i]+D[1][jm1][i])/P[0][jm1][i]
                   +(D[0][jp1][i]+D[1][jp1][i])/P[0][jp1][i]
                    -4.*(D[0][j][i]+D[1][j][i])/P[0][j][i];
        } }

        if(iScale>0){
            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                S[j][i]*=( 20./(1./P[0][j][im1]+1./P[0][j][ip1]
                               +1./P[0][jm1][i]+1./P[0][jp1][i]
                               +16./P[0][j][i]) );
            } }

        }

   /*-----------------*/
    }else if(nD2==2){
   /*-----------------*/

        if(iScale==0){

            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                S[j][i]=D[0][j][im1]/P[0][j][im1]
                       +D[0][j][ip1]/P[0][j][ip1]
                       +D[1][jm1][i]/P[0][jm1][i]
                       +D[1][jp1][i]/P[0][jp1][i]
                       -2.*(D[0][j][i]+D[1][j][i])/P[0][j][i];
            } }

        }else{

            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                im2=max(i-2,0); ip2=min(i+2,nxm1);
            for(j=0;j<ny;j++){
                QW=P[0][j][im1]*P[0][j][i];
                QC=P[0][j][im1]*P[0][j][ip1];
                QE=P[0][j][i]*P[0][j][ip1];
                S[j][i]=6.*( U[j][i]
                          +(QE*U[j][im2]-2.*(QC+QE)*U[j][im1]
                           -2.*(QW+QC)*U[j][ip1]+QW*U[j][ip2])/(QW+4.*QC+QE) );
            } }

            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
                jm2=max(j-2,0); jp2=min(j+2,nym1);
            for(i=0;i<nx;i++){
                QS=P[0][jm1][i]*P[0][j][i];
                QC=P[0][jm1][i]*P[0][jp1][i];
                QN=P[0][j][i]*P[0][jp1][i];
                S[j][i]+=6.*( U[j][i]
                          +(QN*U[jm2][i]-2.*(QC+QN)*U[jm1][i]
                           -2.*(QS+QC)*U[jp1][i]+QS*U[jp2][i])/(QS+4.*QC+QN) );
            } }

        }

   /*-----------------*/
    }else if(nD2==3){
   /*-----------------*/

        if(iScale==0){

            if(nRho==1){

                for(j=0;j<ny;j++){
                    jm1=max(j-1,0); jp1=min(j+1,nym1);
                for(i=0;i<nx;i++){
                    im1=max(i-1,0); ip1=min(i+1,nxm1);
                    S[j][i]=D[0][j][im1]/P[0][j][im1]
                           +D[0][j][ip1]/P[0][j][ip1]
                           +D[1][jm1][i]/P[1][jm1][i]
                           +D[1][jp1][i]/P[1][jp1][i]
                           -2.*D[0][j][i]/P[0][j][i]
                           -2.*D[1][j][i]/P[1][j][i];
                } }

            }else{

                for(j=0;j<ny;j++){
                    jm1=max(j-1,0); jp1=min(j+1,nym1);
                for(i=0;i<nx;i++){
                    im1=max(i-1,0); ip1=min(i+1,nxm1);
                    S[j][i]=D[0][j][im1]/P[0][j][im1]
                           +D[0][j][ip1]/P[0][j][ip1]
                           +D[1][jm1][i]/P[0][jm1][i]
                           +D[1][jp1][i]/P[0][jp1][i]
                           -2.*(D[0][j][i]+D[1][j][i])/P[0][j][i];
                } }
            }

        }else{

            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                im2=max(i-2,0); ip2=min(i+2,nxm1);
            for(j=0;j<ny;j++){
                QW=P[0][j][im1]*P[0][j][i];
                QC=P[0][j][im1]*P[0][j][ip1];
                QE=P[0][j][i]*P[0][j][ip1];
                S[j][i]=6.*( U[j][i]
                          +(QE*U[j][im2]-2.*(QC+QE)*U[j][im1]
                           -2.*(QW+QC)*U[j][ip1]+QW*U[j][ip2])/(QW+4.*QC+QE) );
            } }

            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
                jm2=max(j-2,0); jp2=min(j+2,nym1);
            for(i=0;i<nx;i++){
                QS=P[1][jm1][i]*P[1][j][i];
                QC=P[1][jm1][i]*P[1][jp1][i];
                QN=P[1][j][i]*P[1][jp1][i];
                S[j][i]+=6.*( U[j][i]
                          +(QN*U[jm2][i]-2.*(QC+QN)*U[jm1][i]
                           -2.*(QS+QC)*U[jp1][i]+QS*U[jp2][i])/(QS+4.*QC+QN) );
            } }


        }

   /*-----------------*/
    }else if(nD2==4 || nD2==5){
   /*-----------------*/

        z2=2.*zeta;

        if(iScale==0){

            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                S[j][i]=D[0][j][im1]/P[0][j][im1]
                       +D[0][j][ip1]/P[0][j][ip1]
                       +D[1][jm1][i]/P[0][jm1][i]
                       +D[1][jp1][i]/P[0][jp1][i]
                       -2.*(D[0][j][i]+D[1][j][i])/P[0][j][i]
                       +z2*(
                        D[2][jp1][ip1]/P[0][jp1][ip1]
                       +D[2][jm1][im1]/P[0][jm1][im1]
                       -D[2][jp1][im1]/P[0][jp1][im1]
                       -D[2][jm1][ip1]/P[0][jm1][ip1]
                           );
            } }

        }else{

            printf("Error: getS.c: nD2=%d iScale=%d\n",nD2,iScale);
           *ierr=1; return;

        }


   /*-----------------*/
    }else{
   /*-----------------*/

        printf("Error: getS.c: nD2=%d\n",nD2); *ierr=1; return;

   /*-----------------*/
    }
   /*-----------------*/

}

