#include "H1.h"

void getP(nx,ny,nD2,nRho,level,ierr,
          alpha,K_PM,zeta,epsilon,D,P)

    ITYPE nx,ny,nD2,nRho,level,*ierr;
    VTYPE alpha,K_PM,zeta,epsilon;
    ATYPE D[][ny][nx],P[][ny][nx];

{
    ITYPE i,j,k,id_I;
    VTYPE ep2,rK2,hal,z2;


    if(level>=1){
       printf(" getP: nx=%d ny=%d nD2=%d nRho=%d\n", nx,ny,nD2,nRho);
       printf("       alpha=%g K_PM=%g zeta=%g epsilon=%g\n",
                      alpha,K_PM,zeta,epsilon);
    }


    /*************************/
    /* Initial Check/Setting */
    /*************************/

    if(nD2==0) return;  /* ITV: a special case for second-order PDE */

    if(fabs(alpha-1.)<1.e-5) id_I=1; else id_I=0;
    hal=0.5*(2.-alpha);

    if(nRho<1 || nRho>3){
        printf("Error: getP.c: nRho=%d\n",nRho); *ierr=1; return; }

    ep2=epsilon*epsilon;
    rK2=1./(K_PM*K_PM);


    /*********/
    /* Get P */
    /*********/

   /*-----------------*/
    if(nD2==0){
   /*-----------------*/
        ;

   /*-----------------*/
    }else if(nD2==1){
   /*-----------------*/

        if(nRho==1)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                if(id_I)
                P[0][j][i]=sqrt(pow((D[0][j][i]+D[1][j][i]),2)+ep2);
                else
                P[0][j][i]=pow((pow((D[0][j][i]+D[1][j][i]),2)+ep2),hal);
        else if(nRho==2)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=1.+pow((D[0][j][i]+D[1][j][i]),2)*rK2;
        else
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=exp(pow((D[0][j][i]+D[1][j][i]),2)*rK2);

   /*-----------------*/
    }else if(nD2==2){
   /*-----------------*/

        if(nRho==1)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
               if(id_I)
               P[0][j][i]=sqrt(D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i]+ep2);
               else
               P[0][j][i]=pow(
                       (D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i]+ep2),hal);
        else if(nRho==2)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=1.+(D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i])*rK2;
        else
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
              P[0][j][i]=exp((D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i])*rK2);

   /*-----------------*/
    }else if(nD2==3){
   /*-----------------*/

        if(nRho==1)
            for(k=0;k<2;k++)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                if(id_I)
                    P[k][j][i]=sqrt(D[k][j][i]*D[k][j][i]+ep2);
                else
                    P[k][j][i]=pow((D[k][j][i]*D[k][j][i]+ep2),hal);
        else if(nRho==2)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=1.+pow((fabs(D[0][j][i])+fabs(D[1][j][i])),2)*rK2;
        else{
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=exp(pow((fabs(D[0][j][i])+fabs(D[1][j][i])),2)*rK2);
        }

   /*-----------------*/
    }else if(nD2==4 || nD2==5){
   /*-----------------*/

        z2=2.*zeta;

        if(nRho==1)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                if(id_I)
                P[0][j][i]=sqrt(D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i]
                            +z2*D[2][j][i]*D[2][j][i]+ep2);
                else
                P[0][j][i]=pow((D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i]
                            +z2*D[2][j][i]*D[2][j][i]+ep2),hal);
        else if(nRho==2)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=1.+(D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i]
                           +z2*D[2][j][i]*D[2][j][i])*rK2;
        else
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                P[0][j][i]=exp((D[0][j][i]*D[0][j][i]+D[1][j][i]*D[1][j][i]
                            +z2*D[2][j][i]*D[2][j][i])*rK2);

   /*-----------------*/
    }else{
   /*-----------------*/

        printf("Error: getP.c: nD2=%d\n",nD2); *ierr=1; return;

   /*-----------------*/
    }
   /*-----------------*/

}

