#include "H1.h"

void getLambda(nx,ny,level,ierr,sigma_sq,beta0,beta1,U0,U,S,Lambda)

    ITYPE nx,ny,level,*ierr;
    VTYPE sigma_sq,beta0,beta1;
    ATYPE U0[][nx],U[][nx],S[][nx],Lambda[][nx];

{
    ITYPE i,j;
    VTYPE UC,fac;
    ITYPE nxm1,nym1,im1,ip1,jm1,jp1;

    if(level>=1)
         printf(" getLambda: nx=%d ny=%d beta0=%g beta1=%g sigma_sq=%g\n",
                  nx,ny,beta0,beta1,sigma_sq);

    nxm1=nx-1;
    nym1=ny-1;
    fac=beta1/sigma_sq;


    /**************/
    /* Get Lambda */
    /**************/

    for(j=0;j<ny;j++) for(i=0;i<nx;i++) Lambda[j][i]=beta0;

    if(fabs(beta1)<1.0e-6) return;

    for(j=0;j<ny;j++){
        jm1=max(j-1,0); jp1=min(j+1,nym1);
    for(i=0;i<nx;i++){
        im1=max(i-1,0); ip1=min(i+1,nxm1);
        //UC=0.2*(U[j][i]+U[j][im1]+U[j][ip1]+U[jm1][i]+U[jp1][i]);
        UC=U[j][i];
        Lambda[j][i]+=fac*fabs((U0[j][i]-UC)*S[j][i]);

    } }

}

