#include "H1.h"

void getITV(nx,ny,itMax,iR,level,ierr,epsilon,tol,U,wksp)

    ITYPE nx,ny,itMax,*iR,level,*ierr;
    VTYPE epsilon,tol;
    ATYPE U[][ny][nx],wksp[][ny][nx];

{
    ITYPE i,j,it;
    ITYPE im,ip,jm,jp,id0,id1;
    ITYPE nxm1,nym1;
    VTYPE ep_sq,ux,uy,aW,aE,aS,aN,fac;
    VTYPE err8,err8_0;

    if(level>=1) printf(" getITV: nx=%d ny=%d itMax=%d\n",nx,ny,itMax);

    nxm1=nx-1;
    nym1=ny-1;
    ep_sq=epsilon*epsilon;


    /*-----------------------*/
    for(it=1;it<=itMax;it++){
    /*-----------------------*/

        id0=((it+1)%2);
        id1=(it%2);


        /* Compute d_W/d_E */

        for(j=0;j<ny;j++){
            jm=max(j-1,0); jp=min(j+1,nym1);
        for(i=0;i<nxm1;i++){
            ip=i+1;
            ux=U[id0][j][ip]-U[id0][j][i];
            uy=0.25*(U[id0][jp][ip]+U[id0][jp][i]
                    -U[id0][jm][ip]-U[id0][jm][i]);
            wksp[0][j][i]=sqrt(ux*ux+uy*uy+ep_sq);
        } }
        for(j=0;j<ny;j++) wksp[0][j][nxm1]=wksp[0][j][nxm1-1];


        /* Compute d_S/d_N */

        for(j=0;j<nym1;j++){
            jp=j+1;
        for(i=0;i<nx;i++){
            im=max(i-1,0); ip=min(i+1,nxm1);
            uy=U[id0][jp][i]-U[id0][j][i];
            ux=0.25*(U[id0][jp][ip]+U[id0][j][ip]
                    -U[id0][jp][im]-U[id0][j][im]);
            wksp[1][j][i]=sqrt(ux*ux+uy*uy+ep_sq);
        } }
        for(i=0;i<nx;i++) wksp[1][nym1][i]=wksp[1][nym1-1][i];


        /* Update U */

        for(j=0;j<ny;j++){
            jm=max(j-1,0); jp=min(j+1,nym1);
        for(i=0;i<nx;i++){
            im=max(i-1,0); ip=min(i+1,nxm1);
            fac=0.5/(wksp[0][j][im]+wksp[0][j][i]);
            aW=wksp[0][j][i] *fac;
            aE=wksp[0][j][im]*fac;
            fac=0.5/(wksp[1][jm][i]+wksp[1][j][i]);
            aS=wksp[1][j][i] *fac;
            aN=wksp[1][jm][i]*fac;
            U[id1][j][i]=aW*U[id0][j][im]+aE*U[id0][j][ip]
                        +aS*U[id0][jm][i]+aN*U[id0][jp][i];
        } }


        /* Check Convergence */

        err8=0.;
        for(j=0;j<ny;j++) for(i=0;i<nx;i++)
            err8=max(err8,fabs(U[id1][j][i]-U[id0][j][i]));

        if(it==1) err8_0=err8;
        else{
            err8/=err8_0;
            if(err8<tol){*iR=id1; return;}
            //printf(" err8[%d]=%g\n",it,err8);
        }

    /*-----------------------*/
    }
    /*-----------------------*/

    *iR=id1;

}

