#include "H1.h"

void getD(nx,ny,nD2,level,ierr,epsilon,U,D)

    ITYPE nx,ny,nD2,level,*ierr;
    VTYPE epsilon;
    ATYPE U[][nx],D[][ny][nx];

{
    ITYPE i,j;
    VTYPE ep_sq,ux,uy;
    ITYPE nxm1,nym1,im,ip,jm,jp;


    if(level>=1)
        printf(" getD: nx=%d ny=%d nD2=%d epsilon=%g\n", nx,ny,nD2,epsilon);

    nxm1=nx-1;
    nym1=ny-1;


    /*********/
    /* Get D */
    /*********/

    /*-------------------------*/
    /* ITV: a Second-order PDE */
    /*-------------------------*/

    if(nD2==0){

        ep_sq=epsilon*epsilon;

        for(j=0;j<ny;j++){
            jm=max(j-1,0); jp=min(j+1,nym1);
        for(i=0;i<nxm1;i++){
            ip=i+1;
            ux=U[j][ip]-U[j][i];
            uy=0.25*(U[jp][ip]+U[jp][i]-U[jm][ip]-U[jm][i]);
            D[0][j][i]=sqrt(ux*ux+uy*uy+ep_sq);
        } }
        for(j=0;j<ny;j++) D[0][j][nxm1]=D[0][j][nxm1-1];

        for(j=0;j<nym1;j++){
            jp=j+1;
        for(i=0;i<nx;i++){
            im=max(i-1,0); ip=min(i+1,nxm1);
            uy=U[jp][i]-U[j][i];
            ux=0.25*(U[jp][ip]+U[j][ip]-U[jp][im]-U[j][im]);
            D[1][j][i]=sqrt(ux*ux+uy*uy+ep_sq);
        } }
        for(i=0;i<nx;i++) D[1][nym1][i]=D[1][nym1-1][i];

        return;
    }


    /*-------------------------*/
    /* Fourth-order PDEs       */
    /*-------------------------*/


    for(i=0;i<nx;i++){
        im=max(i-1,0); ip=min(i+1,nxm1);
        for(j=0;j<ny;j++)
            D[0][j][i]=U[j][im]-2.*U[j][i]+U[j][ip];
    }

    for(j=0;j<ny;j++){
        jm=max(j-1,0); jp=min(j+1,nym1);
        for(i=0;i<nx;i++)
            D[1][j][i]=U[jm][i]-2.*U[j][i]+U[jp][i];
    }


    if(nD2==4 || nD2==5){

        for(j=0;j<ny;j++){
            jm=max(j-1,0); jp=min(j+1,nym1);
        for(i=0;i<nx;i++){
            im=max(i-1,0); ip=min(i+1,nxm1);
                D[2][j][i]=0.25*(U[jp][ip]+U[jm][im]-U[jp][im]-U[jm][ip]);
        } }
    }

}

