#include "H1.h"

void getAijC(nx,ny,nD2,nRho,iScale,level,ierr,zeta,P,AijC)

    ITYPE nx,ny,nD2,nRho,iScale,level,*ierr;
    VTYPE zeta;
    ATYPE P[][ny][nx],AijC[][nx];

{
    ITYPE i,j;
    VTYPE fac;
    ITYPE nxm1,nym1,im1,ip1,jm1,jp1;


    if(level>=1) printf(" getAijC: nx=%d ny=%d nD2=%d nRho=%d iScale=%d\n",
                          nx,ny,nD2,nRho,iScale);

    nxm1=nx-1;
    nym1=ny-1;


    /************/
    /* Get AijC */
    /************/


    if(nD2==0){for(j=0;j<ny;j++) for(i=0;i<nx;i++) AijC[j][i]=4.; return;}


    /*--------------------*/
    if(iScale){
    /*--------------------*/

        if(nD2==1)
            for(j=0;j<ny;j++) for(i=0;i<nx;i++) AijC[j][i]=20.;
        else if(nD2==2 || nD2==3)
            for(j=0;j<ny;j++) for(i=0;i<nx;i++) AijC[j][i]=12.;
        else
            ;

    /*--------------------*/
    }else{
    /*--------------------*/

        if(nD2==3 && nRho==1)

           for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                AijC[j][i]=1./P[0][j][im1]+1./P[0][j][ip1]
                          +1./P[1][jm1][i]+1./P[1][jp1][i]
                          +4.*(1./P[0][j][i]+1./P[1][j][i]);
            } }

        else{

            if(nD2==1) fac=16.0;
            else       fac= 8.0;

            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                AijC[j][i]=1./P[0][j][im1]+1./P[0][j][ip1]
                          +1./P[0][jm1][i]+1./P[0][jp1][i]
                          +fac/P[0][j][i];
            } }

        }

        if(nD2==4 || nD2==5){

            fac=2.0*zeta/16.0;

            for(j=0;j<ny;j++){
                jm1=max(j-1,0); jp1=min(j+1,nym1);
            for(i=0;i<nx;i++){
                im1=max(i-1,0); ip1=min(i+1,nxm1);
                AijC[j][i]+=fac*(1./P[0][jp1][ip1]+1./P[0][jm1][im1]
                                +1./P[0][jp1][im1]+1./P[0][jm1][ip1]);
            } }

        }

    /*--------------------*/
    }
    /*--------------------*/

}

