#include "H1.h"

void explicit_PDE4(nt,nx,ny, nD2,nRho,iScale,iVar_Dt,MCiter,nws,level,ierr,iR,
       alpha,K_PM,beta0,beta1,epsilon,gamma,zeta,tol,MaxIm, UNN,U0,U,wksp)

    ITYPE nt,nx,ny, nD2,nRho,iScale,iVar_Dt,MCiter,nws,level,*ierr,*iR;
    VTYPE alpha,K_PM,beta0,beta1,epsilon,gamma,zeta,tol,MaxIm;
    ATYPE UNN[][nx],U0[][nx],U[][ny][nx],wksp[][ny][nx];

{
    ITYPE i,j,n,id0,id1;
    ITYPE nxm1,nym1,level0;
    ITYPE id_ws,iD,iP,iS,iL,iAC,iConstraint;
    VTYPE sigma_sq,Dt_ij,time=0.;
    VTYPE residual,residu2,residu2_0;

    ITYPE id_NA=1,iPSNR;
    VTYPE PSNR,SNR,PSNR_Max=0.,SNR_Max=0.;

  /***********************************/
  /* Print User-Specified Parameters */
  /***********************************/

    if(level>=1)
        printf("explicit_PDE4: nx=%d ny=%d nt=%d MCiter=%d\n", nx,ny,nt,MCiter);
    if(level>=2){
      printf(" alpha=%g K_PM=%g beta0=%g beta1=%g\n", alpha,K_PM,beta0,beta1);
      printf(" epsilon=%g gamma=%g zeta=%g tol=%g\n", epsilon,gamma,zeta,tol);
      printf(" nD2=%d nRho=%d iScale=%d iVar_Dt=%d nws=%d\n",
               nD2,nRho,iScale,iVar_Dt,nws);
    }


  /*******************/
  /* Initial Setting */
  /*******************/

    level0=0;
    nxm1=nx-1;
    nym1=ny-1;
    if((beta0+beta1)>1.e-5) iConstraint=1; else iConstraint=0;

    id_ws=0;
    iD=id_ws;  id_ws+=2; if(nD2==4 || nD2==5) id_ws++;
    iP=id_ws;  id_ws++;  if(nD2==3) id_ws++;
    iS=id_ws;  id_ws++;  // for diffusion matrix (scaled)
    iL=id_ws;  id_ws++;  // for lambda (scaled)
    iAC=id_ws; id_ws++;  // for the coefficient of u_{ij}

    if(id_ws>nws){
        printf("Error: explicit_PDE4.c: required wksp memory = %d\n",id_ws);
        *ierr=1; return;
    }

    getSigma(nx,ny,level,ierr,&sigma_sq,U0,wksp);


  /*********************/
  /* Explicit Marching */
  /*********************/

    for(n=1;n<=nt;n++){

        id0=((n+1)%2);
        id1=(n%2);        /* U[id0]=u^{n-1}; U[id1]=u^n */

       /*-------------------------*/
       /* compute D and P         */
       /*-------------------------*/

        getD(nx,ny,nD2,level0,ierr,epsilon,U[id0],wksp[iD]);

        getP(nx,ny,nD2,nRho,level0,ierr,
             alpha,K_PM,zeta,epsilon,wksp[iD],wksp[iP]);

        if(*ierr) {printf("Error: explicit_PDE4.c:\n"); return;}

       /*-------------------------*/
       /* get S, Lambda, and  AC  */
       /*-------------------------*/

        getS(nx,ny,nD2,nRho,iScale,level0,ierr,
             zeta,U[id0],wksp[iD],wksp[iP],wksp[iS]);

        if(iConstraint==1 || n<=5){
            getLambda(nx,ny,level0,ierr,sigma_sq,beta0,beta1,
                U0,U[id0],wksp[iS],wksp[iL]);

            getAijC(nx,ny,nD2,nRho,iScale,level0,ierr,
                    zeta,wksp[iP],wksp[iAC]);
        }

        if(*ierr) {printf("Error: explicit_PDE4.c:\n"); return;}


       /*-------------------------*/
       /* determine Dt & update U */
       /*-------------------------*/

        if(iVar_Dt==0 && n<=5){
            Dt_ij=0.0;
            for(j=0;j<ny;j++) for(i=0;i<nx;i++)
                Dt_ij=max(Dt_ij,(wksp[iAC][j][i]+wksp[iL][j][i]));
                Dt_ij=gamma/Dt_ij;
        }
        if(iVar_Dt==0) time+=Dt_ij;

        residu2=0.0;
        for(j=0;j<ny;j++)
        for(i=0;i<nx;i++){
            if(iVar_Dt) Dt_ij=gamma/(wksp[iAC][j][i]+wksp[iL][j][i]);
            residual=wksp[iL][j][i]*(U0[j][i]-U[id0][j][i])-wksp[iS][j][i];
            U[id1][j][i]=U[id0][j][i]+Dt_ij*residual;
            residu2+=(residual*residual);
        }
        residu2=sqrt(residu2/(nx*ny));
        if(n==1) residu2_0=residu2;

        if(level>=1 && (n==1 || n%100==0 || n==nt))
            if(iVar_Dt>0)
                printf("  rel_residu2[%3d]=%g\n",n,residu2/residu2_0);
            else
                printf("  rel_residu2[%3d]=%g; t=%g\n",n,
                          residu2/residu2_0,time);


       /*----------------------------------------------------*/
       /* PSNR Checking: this is only for numerical analysis */
       /*----------------------------------------------------*/

        if(id_NA==1){
            compError(1,nx,ny,level0,ierr,MaxIm,&PSNR,&SNR,UNN,U[id1]);
            if(PSNR>PSNR_Max){PSNR_Max=PSNR; SNR_Max=SNR; iPSNR=n;}
        }
        

       /*-------------------------*/
       /* check for convergence   */
       /*-------------------------*/

        if((residu2/residu2_0)<=tol){
            if(level)
                printf("*** Converge: explicit_PDE4.c: residu2[%d]=%g\n",
                      n,residu2);
            if(id_NA==1)
            printf("*** explicit_PDE4.c: [1;7mMAX_PSNR[%d]=%g; SNR=%g[m\n",
                            iPSNR,PSNR_Max,SNR_Max);
            *iR=id1; return;
        }

    }
    *iR=id1;
    if(id_NA==1)
        printf("*** explicit_PDE4.c: [1;7mMAX_PSNR[%d]=%g; SNR=%g[m\n",
                        iPSNR,PSNR_Max,SNR_Max);

}

