#include "H1.h"

void compError(nD,nx,ny,level,ierr,MaxIm,PSNR,SNR,G,H)

    ITYPE nD,nx,ny,level,*ierr;
    VTYPE MaxIm,*PSNR,*SNR;
    ATYPE G[][ny][nx],H[][ny][nx];

{
    ITYPE i,j,k;
    VTYPE L2Err,L8Err,Signal,tmp;

    if(level>=1) printf("COMP_Error:\n");


   /***************/
   /* Check Error */
   /***************/

    Signal=L2Err=L8Err=0.;

    for(k=0;k<nD;k++)
    for(j=0;j<ny;j++)
    for(i=0;i<nx;i++){
        Signal+=(G[k][j][i]*G[k][j][i]);
        tmp=fabs(G[k][j][i]-H[k][j][i]);
        L2Err+=(tmp*tmp);
        L8Err=max(L8Err,tmp);
    }
    *SNR=Signal/L2Err;
    *PSNR=10.*(log10(nx*ny*nD)+log10(MaxIm*MaxIm)-log10(L2Err));
    L2Err=sqrt(L2Err/(nx*ny*nD));
    if(level>=1)
        printf(" L2Err=%.3g L8Err=%.3g PSNR=%.4g SNR=%g \n",
                 L2Err,L8Err,*PSNR,*SNR);

}

