#include "H1.h"

void PDE4(nt,nx,ny,nC, nD2,nRho,iScale,iVar_Dt,
       MCiter,idata,MZ_Noise,Impulse,nws,level,ierr,
       alpha,K_PM,beta0,beta1,epsilon,gamma,zeta,tol, DATA,U,wksp)

    ITYPE nt,nx,ny,nC, nD2,nRho,iScale,iVar_Dt;
    ITYPE MCiter,idata,MZ_Noise,Impulse,nws,level,*ierr;
    VTYPE *alpha,*K_PM,*beta0,*beta1,*epsilon,*gamma,*zeta,*tol;
    DTYPE DATA[][nx][nC];
    ATYPE U[][ny][nx],wksp[][ny][nx];

{
    ITYPE i,j,k,iU0,iUNN,level0;
    ITYPE neqn,iR;
    VTYPE scale,MaxIm,tmp;
    VTYPE PSNR,PSNR_B,PSNR_C,SNR,SNR_B;
    float utime0,stime0,utime1,stime1;
    char *WARNING,*CHANGE;
    FILE *fp;


  /******************/
  /* Iinial Setting */
  /******************/

    iU0=2;
    iUNN=3;
    level0=0;

    scale=1./255.;
    MaxIm=1.;
    neqn=nx*ny;

    if((*beta0+*beta1)<1.0e-5 && iVar_Dt==1){
        iVar_Dt=0;
        if(level>0)
        printf("*** PDE4.c: beta0=%g beta1=%g: Reset iVar_Dt=%d ***\n",                    beta0,beta1,iVar_Dt);
    }

    if(nRho==0){
        nRho=1; *alpha=1.;
        if(level>0)
        printf("*** PDE4.c: Reset nRho=%d alpha=%g ***\n",
                    nRho,*alpha);
    }

    if(nD2==0){
        nRho=1; *alpha=*gamma=1.;
        if(level>0)
        printf("*** PDE4.c: Reset nRho=%d alpha=%g gamma=%g ***\n",
                    nRho,*alpha,*gamma);
    }

    if(nD2==4){
        *zeta=1.;
        if(level>0)
        printf("*** PDE4.c: Reset zeta=%g ***\n", *zeta);
    }


  /***********************************/
  /* Print User-Specified Parameters */
  /***********************************/

    if(level>=1)
        printf("[1;7mPDE4:[m idata=%d nx=%d ny=%d nC=%d\n",
                         idata,nx,ny,nC);
    if(level>=2){
      printf(" nD2=%d nRho=%d iScale=%d iVar_Dt=%d\n",
               nD2,nRho,iScale,iVar_Dt);
      printf(" alpha=%g K_PM=%g beta0=%g beta1=%g\n",
               *alpha,*K_PM,*beta0,*beta1);
      printf(" epsilon=%g gamma=%g zeta=%g tol=%g\n",
               *epsilon,*gamma,*zeta,*tol);
      printf(" MCiter=%d MZ_Noise=%d Impulse=%d\n",MCiter,MZ_Noise,Impulse);
    }

    if(MCiter>0){
        printf(" Error: PDE4.c: Wrong MCiter=%d\n",MCiter);
        *ierr=1; return;
    }

  /******************/
  /* Transform DATA */
  /******************/


    if(nC==1){

        if(idata>0)
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                U[iUNN][j][i]=scale*DATA[j][i][0];
        else{
            for(j=0;j<ny;j++)
            for(i=0;i<nx;i++)
                if( ((i-nx/2)*(i-nx/2)+(j-ny/2)*(j-ny/2))<=(ny*ny/16) )
                    U[iUNN][j][i]=1.0;
                else
                    U[iUNN][j][i]=0.2;
        }

    }else{

        printf("Error: PDE4.c: wrong nC=%d\n",nC);
         *ierr=1; return;
    }


  /*****************************************/
  /* Set "U_0" as the original noisy image */
  /*****************************************/

    for(j=0;j<ny;j++)
    for(i=0;i<nx;i++)
        U[iU0][j][i]=U[iUNN][j][i];

    if(Impulse>0 || MZ_Noise>0)
        setNoise(nx,ny,neqn,MZ_Noise,Impulse,level,ierr,MaxIm,U[iU0],wksp);

    if(level>=1){
        compError(1,nx,ny,level,ierr,MaxIm,&PSNR_B,&SNR_B,U[iUNN],U[iU0]);
    }

    if(*ierr!=0)return;


  /*===================================*/
  /* Begin:  Denoising                 */
  /*===================================*/

  /**************************/
  /* Initialization for u^0 */
  /**************************/

    for(j=0;j<ny;j++)
    for(i=0;i<nx;i++)
        U[0][j][i]=U[iU0][j][i];


  /*********************/
  /* Now, Clock Begins */
  /*********************/

    if(level>=1){
        #if defined (_IBMR2) || defined (AIX) || defined (hpux)
            etimef77(&utime0,&stime0);
        #else
            etimef77_(&utime0,&stime0);
        #endif
    }


  /*******************/
  /* Call the solver */
  /*******************/

    explicit_PDE4(nt,nx,ny, nD2,nRho,iScale,iVar_Dt,MCiter,nws,level,ierr,&iR,
           *alpha,*K_PM,*beta0,*beta1,*epsilon,*gamma,*zeta,*tol,MaxIm,
           U[iUNN],U[iU0],U,wksp);

    if(*ierr!=0)return;


  /*******************/
  /* Now: Clock Ends */
  /*******************/

    if(level==0) return;

    #if defined (_IBMR2) || defined (AIX) || defined (hpux)
        etimef77(&utime1,&stime1);
    #else
        etimef77_(&utime1,&stime1);
    #endif
    printf("- - - - - - - - - - - - - - - - - - -\n");
    printf("PDE4: ElapsedTime=%.4g\n",utime1-utime0);
    printf("- - - - - - - - - - - - - - - - - - -\n");

    if(level>=1)
        printf("[1;7mPDE4:[m idata=%d nx=%d ny=%d nC=%d\n",
                         idata,nx,ny,nC);
    if(level>=2){
      printf(" nD2=%d nRho=%d iScale=%d iVar_Dt=%d\n",
               nD2,nRho,iScale,iVar_Dt);
      printf(" alpha=%g K_PM=%g beta0=%g beta1=%g\n",
               *alpha,*K_PM,*beta0,*beta1);
      printf(" epsilon=%g gamma=%g zeta=%g tol=%g\n",
               *epsilon,*gamma,*zeta,*tol);
      printf(" MCiter=%d MZ_Noise=%d Impulse=%d\n",MCiter,MZ_Noise,Impulse);
    }

  /************************/
  /* Some Post Processing */
  /************************/

    compError(nC,nx,ny,level0,ierr,MaxIm,&PSNR,&SNR,U[iUNN],U[iR]);
    printf("- - - - - - - - - - - - - - - - - - -\n");
    printf("PSNR(G;U0,U1)=%.4g, %.4g;  SNR(G;U0,U1)=%g, %g\n",
            PSNR_B,PSNR,SNR_B,SNR);

  /*****************/
  /* Save to files */
  /*****************/

    save2file("fort.UNN",nC,nx,ny,1,idata,1,ierr,U[iUNN],wksp);
    save2file("fort.U0", nC,nx,ny,1,idata,1,ierr,U[iU0],wksp);
    save2file("fort.U1", nC,nx,ny,1,idata,1,ierr,U[iR],wksp);

    //if(MZ_Noise>0 || Impulse>0){
        for(j=0;j<ny;j++)
        for(i=0;i<nx;i++)
            U[iR][j][i]=1.0*(U[iUNN][j][i]-U[iR][j][i])+0.5;
        printf(" ****** ABO_2D.c: fort.Res=1.0*(g-u)+128 ******\n");
        save2file("fort.Res",nC,nx,ny,1,idata,1,ierr,U[iR],wksp);
    //}


}

