#include <stdio.h>
#include <math.h>
#include <time.h>

void thesolver(nx,ny,icfcol,itmax,idpcond,level,idpsrc,idsol,
            A,x,ailu,b,tsol,wksp,tol,ierr)

int nx,ny,icfcol;
int itmax,idpcond,level,idpsrc,idsol;
float A[];
float x[];
float ailu[];
float b[];
float tsol[];
float wksp[][nx*ny];
float *tol;
int *ierr;

{
   /*
   float utime0,stime0,utime1,stime1,rtime;
   struct timeval begin,finish;
   struct timezone tzp;
   */

   if(level>=1) printf("THESOLVER: idsol=%d\n",idsol);
   if(level>=2){
      printf(" nx=%d ny=%d itmax=%d tol=%g\n",nx,ny,itmax,*tol);
      printf(" idpcond=%d idpsrc=%d level=%d\n",idpcond,idpsrc,level);
   }

   /*
   if(level>=1){
      #if defined (_IBMR2) || defined (AIX) || defined (hpux)
         etimef77(&utime0,&stime0);
      #else
         etimef77_(&utime0,&stime0);
      #endif
      gettimeofday(&begin,&tzp);
    }
   */

   initialx(nx,ny,level,x,wksp,ierr);

   if (idsol==1){
      ilu0(nx,ny,level,A,ailu,ierr);
      pcg_ilu(nx,ny,itmax,idpcond,level,idpsrc,
              A,x,ailu,b,tsol,wksp,tol,ierr);
      }

   else if(idsol==2){
      icf0(nx,ny,icfcol,level,A,ailu,ierr);
      pcg_icf(nx,ny,icfcol,itmax,idpcond,level,idpsrc,
              A,x,ailu,b,tsol,wksp,tol,ierr);
      }

   else if(idsol==3){
      itmax=10000;
      #if defined (_IBMR2) || defined (AIX) || defined (hpux)
         gausseidel(&nx,&ny,&itmax,&level,&idpsrc,A,x,b,tsol,tol,ierr);
      #else
         gausseidel_(&nx,&ny,&itmax,&level,&idpsrc,A,x,b,tsol,tol,ierr);
      #endif
     }

   else{
      if(level>=1) printf(" No solver is given for idsol=%d\n",idsol);
      *ierr=1;
     }


   /*
   if(level>=1){
      #if defined (_IBMR2) || defined (AIX) || defined (hpux)
         etimef77(&utime1,&stime1);
      #else
         etimef77_(&utime1,&stime1);
      #endif
      gettimeofday (&finish,&tzp);
      if(begin.tv_usec>finish.tv_usec)
         {finish.tv_usec+=1000000; finish.tv_sec--;}
      rtime=finish.tv_sec-begin.tv_sec+(finish.tv_usec-begin.tv_usec)/1.e6;
      printf("ElapsedTime=%gu %gs %.4gr\n",utime1-utime0,stime1-stime0,rtime);
      printf("ElapsedTime=%.4gr\n",rtime);
    }
   */

}
