#include <stdio.h>
#include <math.h>

/*************************************************/
void initialx(nx,ny,level,x,wksp,ierr)
int nx,ny,level;
int *ierr;
float x[];
float wksp[];
{
   int i,j;
   int nxny;
   float zero;

   nxny=nx*ny;
   zero=0.e+0;

   if(level>=2){
      printf("INITIALX: initializes the solution x.\n");
      printf(" nx=%d ny=%d\n level=%d ierr=%d\n",nx,ny,level,*ierr);
     }

   if(level>=2) printf(" Zero initial guess\n");
   for(i=0;i<nxny;i++)
      x[i]=zero;
}

/*************************************************/
void dot_prod(nxny,level,x,y,sum,ierr)
int nxny,level;
int *ierr;
float *sum;
float x[];
float y[];
{
   int i;

   *sum=0.0;
   for(i=0;i<nxny;i++)
      *sum+=x[i]*y[i];
}

/*************************************************/
void numer_anal(nxny,level,a,x,b,tsol,wksp,ierr)
int nxny,level;
float a[],x[],b[];
float tsol[],wksp[];
int *ierr;
{
   int i;
   float errnorm,product;

   for(i=0; i<nxny; i++)
      wksp[i]=tsol[i]-x[i];
   dot_prod(nxny,level,wksp,wksp,&product,ierr);
   errnorm=sqrt(product);

   dot_prod(nxny,level,tsol,tsol,&product,ierr);
   errnorm/=sqrt(product);

   if(level>=1){
      printf("NUMER_ANAL:\n");
      printf(" ||U_true-U_comp||=%g\n",errnorm);
      }
}

