c ======================================================================
      subroutine mtxvec(nx,ny,a,x,y,level,ierr)
c ======================================================================
c matrix-vector multiplication for row-compact matrix
c obtained from the 5-point finite difference method for
c 2D partial differential equations (PDE).
c INPUT:
c   a:  the matrix
c   x:  the vector
c OUTPUT:
c   y = a x
c----------------------------------------------------------------------
      implicit none
      integer nx,ny,level,ierr
      real a(5,nx,ny),x(nx,ny),y(nx,ny)

      integer i,j,nxm1,nym1,jm1,jp1

      if (level.ge.4) then
         print'("MTXVEC: matrix vector multiplication")'
         print*,"dim(A)=",nx*ny
      endif

      nxm1=nx-1
      nym1=ny-1

c---- interior points

      do j=2,nym1
         jm1=j-1
         jp1=j+1
      do i=2,nxm1
         y(i,j)=a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)+a(3,i,j)*x(i,j)
     &         +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1)
      end do
      end do

c---- four corners

      i=1
      j=1
      y(i,j)=a(3,i,j)*x(i,j)+a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,j+1)

      i=nx
      j=1
      y(i,j)=a(3,i,j)*x(i,j)+a(2,i,j)*x(i-1,j)+a(5,i,j)*x(i,j+1)

      i=1
      j=ny
      y(i,j)=a(3,i,j)*x(i,j)+a(1,i,j)*x(i,j-1)+a(4,i,j)*x(i+1,j)

      i=nx
      j=ny
      y(i,j)=a(3,i,j)*x(i,j)+a(1,i,j)*x(i,j-1)+a(2,i,j)*x(i-1,j)

c---- four sides

      i=1
      do j=2,nym1
         y(i,j)=a(1,i,j)*x(i,j-1)+a(3,i,j)*x(i,j)
     &         +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,j+1)
      end do

      i=nx
      do j=2,nym1
         y(i,j)=a(1,i,j)*x(i,j-1)+a(2,i,j)*x(i-1,j)
     &         +a(3,i,j)*x(i,j)+a(5,i,j)*x(i,j+1)
      end do

      j=1
      do i=2,nxm1
         y(i,j)=a(2,i,j)*x(i-1,j)+a(3,i,j)*x(i,j)
     &         +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,j+1)
      end do

      j=ny
      do i=2,nxm1
         y(i,j)=a(1,i,j)*x(i,j-1)+a(2,i,j)*x(i-1,j)
     &         +a(3,i,j)*x(i,j)+a(4,i,j)*x(i+1,j)
      end do

      return
      end

