!=======================================================================
      subroutine matrix(nx,ny,ax,bx,ay,by,nperm,ncc,nbc,idpsrc,artdamp,
     &       a,b,tsol,imode,level,ierr)
!=======================================================================
      implicit none
      integer nx,ny,nperm,ncc,nbc,idpsrc,imode,level,ierr
      real    ax,bx,ay,by,artdamp
      real    a(5,nx,ny),b(nx,ny),tsol(nx,ny)

! imode=0: make all
! imode=1: make a & b
! imode=2: make tsol

      integer i,j,k,idsym
      real    hx,hy,px,py,hx2,twohx,hxohy,hxohy2,de,dw,dn,ds,diag
      real    ftnperm,r1prhs,ftng,ftnsol,atten
      include 'commons.h'
      integer np0,nc0,nb0
      real    pi,cox,coy,tmp

      if(imode.lt.0.or.imode.gt.2) then
         print'("Error from MATRIX: imode=",i2)',imode
         ierr=1
         return
      endif

      if(level.ge.2) print'("MATRIX: imode=",i2)',imode

      idsym=1

      np0=nperm
      nc0=ncc
      nb0=nbc
      pi=4.*atan(1.0)
      cox=6.*pi
      coy=5.*pi

      hx=(bx-ax)/float(nx-1)
      hy=(by-ay)/float(ny-1)

      hx2   = hx**2
      twohx = 2.*hx
      hxohy = hx/hy
      hxohy2= hxohy**2
      atten = artdamp*hx2

      if (imode.eq.2) goto 2000

!--- MAKE A -----------------

      do j=1,ny
         py=hy*dble(j-1)+ay
      do i=1,nx
         px=hx*dble(i-1)+ax
         call setpar(nx,ny,i,j,px,py,hx,hy,hx2,twohx,hxohy,hxohy2,
     &               de,dw,dn,ds,diag)
         a(1,i,j)=-ds
         a(2,i,j)=-dw
         a(3,i,j)=diag+atten
         a(4,i,j)=-de
         a(5,i,j)=-dn
      end do
      end do

!--- MAKE B -----------------

      if (idpsrc.eq.1) then

         do j =1,ny
         do i =1,nx
            b(i,j)=0.0
         end do
         end do
         b(max(1, (nx+1)/2-3),(ny+1)/2)=-1.0
         b(min(nx,(nx+1)/2+3),(ny+1)/2)= 1.0

      else

         do j=1,ny
             py=hy*dble(j-1)+ay
         do i=1,nx
             px=hx*dble(i-1)+ax
             b(i,j)=r1prhs(px,py)*hx2
         end do
         end do

         px=ax
         i=1
         do j=1,ny
             py=hy*dble(j-1)+ay
             b(i,j)=b(i,j)+twohx*ftng(px,py,1)
         end do

         px=bx
         i=nx
         do j=1,ny
             py=hy*dble(j-1)+ay
             b(i,j)=b(i,j)+twohx*ftng(px,py,2)
         end do

         py=ay
         j=1
         do i=1,nx
             px=dble(i-1)*hx+ax
             b(i,j)=b(i,j)+twohx*ftng(px,py,3)*hxohy
         end do

         py=by
         j=ny
         do i=1,nx
             px=dble(i-1)*hx+ax
             b(i,j)=b(i,j)+twohx*ftng(px,py,4)*hxohy
         end do

      end if

! Symmetrize the matrix

      if(idsym.eq.1) then

         do j=1,ny,(ny-1)
         do i=1,nx
            do k=1,5
               a(k,i,j)=0.5*a(k,i,j)
            enddo
            b(i,j)=0.5*b(i,j)
         enddo
         enddo

         do i=1,nx,(nx-1)
         do j=1,ny
            do k=1,5
               a(k,i,j)=0.5*a(k,i,j)
            enddo
            b(i,j)=0.5*b(i,j)
         enddo
         enddo

      endif

! now, nonsingular-izing

      if (ncc.eq.0 .and. nbc.eq.0) then
         tmp=a(3,1,1)
         a(3,1,1)=tmp+tmp
         if(idpsrc.eq.1) then
            b(1,1)=b(1,1)+tmp*hx2*ftnperm(ax,ay)   ! for practical problems
         else
!            b(1,1)=b(1,1)+tmp*(ftnsol(ax,ay)+hx2*ftnperm(ax,ay))
            b(1,1)=b(1,1)+tmp*ftnsol(ax,ay)        ! compare these two
         endif
      endif

      if(level.ge.2) print'(1x,a)','produce A and b'

      if(imode.eq.1) goto 9999
 2000 continue

!--- MAKE TSOL -----------------

      if(idpsrc.ne.1) then
         do j=1,ny
             py=hy*real(j-1)+ay
         do i=1,nx
             px=hx*real(i-1)+ax
             tsol(i,j)=ftnsol(px,py)
         end do
         end do
         if(level.ge.2) print'(1x,a)','produce tsol'
      endif

 9999 continue

      if(level.ge.3) then
         do j=1,ny
         do i=1,nx
           print'(" A(.,",i3,",",i3,")=",5(f10.5))',i,j,(a(k,i,j),k=1,5)
         enddo
         enddo
      endif

      return
      end

c ======================================================================
      subroutine setpar(nx,ny,i,j,px,py,hx,hy,hx2,twohx,hxohy,hxohy2,
     &      de,dw,dn,ds,diag)
c ======================================================================
      implicit none
      integer nx,ny,i,j
      real    px,py,hx,hy,hx2,twohx,hxohy,hxohy2,de,dw,dn,ds,diag

      real    t0,t1,t2,t3,t4,bdry,ftnperm,ftnc,ftnbeta

      t0=ftnperm(px,py)
      t1=ftnperm(px-hx,py)
      t2=ftnperm(px+hx,py)
      t3=ftnperm(px,py-hy)
      t4=ftnperm(px,py+hy)

      dw=0.5*(t0+t1)
      de=0.5*(t0+t2)
      ds=0.5*(t0+t3)*hxohy2
      dn=0.5*(t0+t4)*hxohy2
      bdry=0.0

c----------------------------------

      if (i.eq.1) then
         dw=0.0
         de=2.*de
         bdry=ftnbeta(px,py)*twohx
      else if (i.eq.nx) then
         de=0.0
         dw=2.*dw
         bdry=ftnbeta(px,py)*twohx
      end if

      if (j.eq.1) then
         ds=0.0
         dn=2.*dn
         bdry=bdry+ftnbeta(px,py)*twohx*hxohy
      else if (j.eq.ny) then
         dn=0.0
         ds=2.*ds
         bdry=bdry+ftnbeta(px,py)*twohx*hxohy
      end if

c----------------------------------

      diag=de+dw+ds+dn +ftnc(px,py)*hx2 +bdry

      return
      end

