c=======================================================================
      real function ftnperm(x,y)
c=======================================================================
      include 'commons.h'

      if (np0.eq.0) then
          ftnperm=1.0
      else if (np0.eq.1 .or. np0.eq.2) then
          ftnperm=1./(2.+x**2+sin(pi*y))
      else
          print*,"Please, edit input.f to specify your problem"
          stop
      endif

      return
      end

c=======================================================================
      real function dxperm(x,y)
c=======================================================================
c the x-derivative of ftnperm
      include 'commons.h'

      if (np0.eq.0) then
          dxperm=0.0
      else if (np0.eq.1 .or. np0.eq.2) then
          dxperm=-2.*x* (ftnperm(x,y))**2
      else
      endif

      return
      end

c=======================================================================
      real function dyperm(x,y)
c=======================================================================
c the y-derivative of ftnperm
      include 'commons.h'

      if (np0.eq.0) then
          dyperm=0.0
      else if (np0.eq.1 .or. np0.eq.2) then
          dyperm=-pi*cos(pi*y)* (ftnperm(x,y))**2
      else
      endif

      return
      end

c=======================================================================
      real function ftnc(x,y)
c=======================================================================
      include 'commons.h'

      if(nc0.eq.0) then
         ftnc=0.0
      else if(nc0.ge.1) then
         ftnc=5.0
      endif

      return
      end

c=======================================================================
      real function ftnbeta(x,y)
c=======================================================================
      include 'commons.h'

      if(nb0.eq.0) then
         ftnbeta=0.0
      else if(nb0.ge.1) then
         ftnbeta=1.0
      endif

      return
      end

c=======================================================================
      real function ftnsol(x,y)
c=======================================================================
      include 'commons.h'
      if(np0.eq.0.or.np0.eq.1) then
         ftnsol =x**2 +5.*x +y**2 +3.
      else
         ftnsol = sin(cox*x)*cos(coy*y)
      endif
      return
      end

c=======================================================================
      real function dxsol(x,y)
c=======================================================================
      include 'commons.h'
      if(np0.eq.0.or.np0.eq.1) then
         dxsol=2.*x +5.
      else
         dxsol=cox*cos(cox*x)*cos(coy*y)
      endif
      return
      end

c=======================================================================
      real function dxxsol(x,y)
c=======================================================================
      include 'commons.h'
      if(np0.eq.0.or.np0.eq.1) then
         dxxsol=2.0
      else
         dxxsol=-cox**2*ftnsol(x,y)
      endif
      return
      end

c=======================================================================
      real function dysol(x,y)
c=======================================================================
      include 'commons.h'
      if(np0.eq.0.or.np0.eq.1) then
         dysol=2.0*y
      else
         dysol=-coy*sin(cox*x)*sin(coy*y)
      endif
      return
      end

c=======================================================================
      real function dyysol(x,y)
c=======================================================================
      include 'commons.h'
      if(np0.eq.0.or.np0.eq.1) then
         dyysol=2.0
      else
         dyysol=-coy**2 * ftnsol(x,y)
      endif
      return
      end

c=======================================================================
!=== DON'T TOUCH BELOW HERE ============================================
c=======================================================================

c=======================================================================
      real function r1prhs(x,y)
c=======================================================================
      r1prhs =ftnc(x,y)*ftnsol(x,y)
     &       -(dxperm(x,y)*dxsol(x,y)+dyperm(x,y)*dysol(x,y))
     &       -ftnperm(x,y)*(dxxsol(x,y)+dyysol(x,y))
      return
      end

c=======================================================================
      real function ftng(x,y,iside)
c=======================================================================
      bdry0 = ftnbeta(x,y)*ftnsol(x,y)

      goto(10,20,30,40),iside
 10   ftng=-ftnperm(x,y)*dxsol(x,y)+bdry0
      goto 9999
 20   ftng= ftnperm(x,y)*dxsol(x,y)+bdry0
      goto 9999
 30   ftng=-ftnperm(x,y)*dysol(x,y)+bdry0
      goto 9999
 40   ftng= ftnperm(x,y)*dysol(x,y)+bdry0
 
 9999 return
      end

