#include <stdio.h>
#include <math.h>

void ilu0(nx,ny,level,a,ailu,ierr)
int nx,ny,level;
int *ierr;
float a[][nx][5];
float ailu[][nx][5];
{
   int i,j,nxm1,nym1,jp1;
   float pivot,mul,pivot_min;
   int   notdone,itcount,maxiter;
   float diag_add,diag_more;

   pivot_min=1.e-2;
   itcount=0;
   maxiter=10;
   diag_add=0.0;
   diag_more=0.1;

   if(level>=2){
      printf("ILU0: Incomplete LU Factorization\n");
      printf(" [a stabilized outer-product form]\n");
      printf(" nx=%d ny=%d\n level=%d ierr=%d\n",nx,ny,level,*ierr);
     }

   nxm1=nx-1;
   nym1=ny-1;

   do{ notdone=0;
       for(j=0; j<ny; j++)
       for(i=0; i<nx; i++){
          ailu[j][i][0]=a[j][i][0];
          ailu[j][i][1]=a[j][i][1];
          ailu[j][i][2]=a[j][i][2]+diag_add;
          ailu[j][i][3]=a[j][i][3];
          ailu[j][i][4]=a[j][i][4];
          }

       for(j=0; j<ny; j++){
          jp1=j+1;
          for(i=0; i<nx; i++){
             pivot=ailu[j][i][2];
             if(pivot<pivot_min){
                printf("ILU0: pivot < pivot_min: Let us try again.\n");
                notdone=1; break;
                }
             if(i<nxm1){
                mul=ailu[j][i+1][1]/pivot;
                ailu[j][i+1][1] =mul;
                ailu[j][i+1][2]-=mul*ailu[j][i][3];
                }

             if(j<nym1){
                mul=ailu[jp1][i][0]/pivot;
                ailu[jp1][i][0] =mul;
                ailu[jp1][i][2]-=mul*ailu[j][i][4];
                }
             }
             if(notdone) break;
          }  /* end of the nested loop */

       if( (++itcount>=maxiter) && (notdone) ) {
           printf("ERROR from ILU0:\n");
           printf(" after %d iterations, still pivot < pivot_min.\n",itcount);
           *ierr=44; return;
           }

       diag_add+=diag_more;

    } while(notdone);


   /*************** print out ***************/

   if(level>=3){
      for(j=0; j<ny; j++)
         for(i=0; i<nx; i++)
             printf(" ailu[%d][%d][]=%f  %f  %f  %f  %f\n", j,i,
                ailu[j][i][0],ailu[j][i][1],ailu[j][i][2],
                ailu[j][i][3],ailu[j][i][4]);
      }
}
