#include <stdio.h>
#include <math.h>

void icf0(nx,ny,icfcol,level,a,aicf,ierr)
int nx,ny,icfcol,level;
int *ierr;
float a[][nx][5];
float aicf[][nx][icfcol];
{
   int i,j,nxm1,nym1,jp1;
   float pivot,gkk,pivot_min;
   int   notdone,itcount,maxiter;
   float diag_add,diag_more;

   if (icfcol!=3 && icfcol!=5){
      printf("Error from ICF0: icfcol should be 3 or 5.\n");
      *ierr=1; return;
      }
     
   pivot_min=1.e-3;
   itcount=0;
   maxiter=10;
   diag_add=0.0;
   diag_more=0.1;

   if(level>=2){
      printf("ICF0: Incomplete Cholesky Factorization\n");
      printf(" [a stabilized inner-product form]\n");
      printf(" nx=%d ny=%d\n level=%d ierr=%d\n",nx,ny,level,*ierr);
     }

   nxm1=nx-1;
   nym1=ny-1;

   do{ notdone=0;

       for(j=0; j<ny; j++)
       for(i=0; i<nx; i++){
          aicf[j][i][0]=a[j][i][0];
          aicf[j][i][1]=a[j][i][1];
          aicf[j][i][2]=a[j][i][2]+diag_add;
          }

       for(j=0; j<ny; j++){
          jp1=j+1;
          for(i=0; i<nx; i++){
             pivot=aicf[j][i][2]-=(aicf[j][i][0]*aicf[j][i][0]
                                  +aicf[j][i][1]*aicf[j][i][1]);
             if(pivot<pivot_min){
                printf("ICF0: pivot < pivot_min: Let us try again.\n");
                notdone=1; break;}
             gkk=sqrt(pivot);
             aicf[j][i][2]=gkk;
             if(i<nxm1) aicf[j][i+1][1] /= gkk;
             if(j<nym1) aicf[jp1][i][0] /= gkk;
             }
             if(notdone) break;
          }  /* end of the nested loop */

       if( (++itcount>=maxiter) && (notdone) ) {
           printf("ERROR from ICF0:\n");
           printf(" after %d iterations, still pivot < pivot_min.\n",itcount);
           *ierr=33; return;
           }

       diag_add+=diag_more;

    } while(notdone);

   /* symmetrized saving for the case: icfcol=5 */

    if(icfcol==5){
       for(j=0; j<ny; j++){
          jp1=j+1;
          for(i=0; i<nx; i++){
             if(i<nxm1) aicf[j][i][3]=aicf[j][i+1][1];
             if(j<nym1) aicf[j][i][4]=aicf[jp1][i][0];
             }
          }
       }

   /*************** print out ***************/

   if(level>=3){
      if(icfcol==5){
         for(j=0; j<ny; j++)
            for(i=0; i<nx; i++)
                printf(" aicf[%d][%d][]=%f  %f  %f  %f  %f\n", j,i,
                   aicf[j][i][0],aicf[j][i][1],aicf[j][i][2],
                   aicf[j][i][3],aicf[j][i][4]);
         }
      else{
         for(j=0; j<ny; j++)
            for(i=0; i<nx; i++)
                printf(" aicf[%d][%d][]=%f  %f  %f\n", j,i,
                   aicf[j][i][0],aicf[j][i][1],aicf[j][i][2]);
         }
   }
}
