!=======================================================================
      subroutine OneWayWave(nt,nx,level,idsol,ierr,
     &     at,bt,ax,bx,vel,epsilon,theta, A,B,F,U,wksp)
!=======================================================================
      implicit none
      integer nt,nx,level,idsol,ierr
      real*8  at,bt,ax,bx,vel,epsilon,theta
      real*8  A(3,0:nx),B(3,0:nx),F(3,0:nx),U(0:nx,0:1)
      real*8  wksp(0:nx)

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,n,id0,id1
      integer level0,nband
      real*8  ht,hx,lambda,eps0
      real*4  utime0,stime0,utime1,stime1
      character*40 scheme

!------------------------------------
!---- basic checking and setting
!------------------------------------

      eps0=1.d-6
      level0=0
      nband=1

      scheme='NONE'
      if(idsol.eq.1)  scheme='Backward-Space'
      if(idsol.eq.2)  scheme='Central-Space'
      if(idsol.eq.3)  scheme='Forward-Space'

      if(scheme.eq.'NONE')then
          print*,"Error: OneWayWave.f: Wrong idsol"
          ierr=1
          return
      endif

      if( min(dabs(theta-0.),dabs(theta-0.5),dabs(theta-1.))
     &         .gt.eps0 ) then
          print*,"Error: OneWayWave.f: theta must be 0.0, 0.5, or 1.0."
          ierr=1
          return
      endif

      hx=(bx-ax)/dble(nx)
      ht=(bt-at)/dble(nt)
      lambda=ht/hx

      if( (theta.le.eps0 .and. dabs(vel*lambda).gt.1.d0) .or.
     &    (idsol.eq.2 .and. theta.lt.eps0) )then
          print*,"|vel*lambda|=",dabs(vel*lambda)
          print'(1x,40("-"))'
          print*,"Error: OneWayWave.f: Stability violated."
          print'(1x,40("-"))'
          ierr=1
          return
      endif


      call etimef77(utime0,stime0)

!------------------------------------
!---- Print out information
!------------------------------------

      if(level.ge.1)then
         print'("OneWayWave: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.2)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"vel=",vel," epsilon=",epsilon," theta=",theta
         print*,"|vel*lambda|=",dabs(vel*lambda)
      endif


!------------------------------------
!---- Set initial values
!------------------------------------

      call getU0(nx,level0,ierr,ax,bx,vel,U(0,0))

      if(ierr.ne.0)then
          print*,"Error: OneWayWave.f: from getU0"
          return
      endif


!------------------------------------
!---- Construct "A"
!------------------------------------

      call getA(nx,idsol,level,ierr,ax,bx,vel,epsilon,A)

      if(ierr.ne.0)then
          print*,"Error: OneWayWave.f: from getA"
          return
      endif


!------------------------------------
!---- Construct "B" and "F"
!------------------------------------

      call getBF(nx,nt,idsol,level,ierr,
     &           ax,bx,at,bt,theta, A,B,F)

      if(ierr.ne.0)then
          print*,"Error: OneWayWave.f: from getBF"
          return
      endif

!------------------------------------
!---- First, LU factorization for B
!------------------------------------

      if(theta.gt.eps0)then
          call lufac(nband,nx+1,level0,B)
      endif


!------------------------------------
!---- Now, time-marching
!------------------------------------

      do 8888 n=1,nt

          id0=mod(n+1,2)
          id1=mod(n,2)

          call getFU(nx,idsol,level0,ierr,F,U(0,id0),U(0,id1))

          if(theta.gt.eps0)then
              call substit(nband,nx+1,level0,B,U(0,id1))
          endif

 8888 continue


!------------------------------------
!---- Print out the results
!------------------------------------

 9999 if(level.le.1) return

      print'(40("-"))'
      call etimef77(utime1,stime1)
      print'("Elapsed Time=",f7.2)',utime1-utime0

      open(1,file="fort.0")
         write(1,*) scheme
      close(1)
      open(1,file="fort.1")
         write(1,*) nx,ax,bx,hx,nt,at,bt,ht,theta
      close(1)

      open(68,file="fort.sol")
      print*,"<fort.sol>  contains computed solution at t=",bt
      do j=0,nx
         write(68,*) ax+dble(j)*hx,U(j,id1)
      enddo
      close(68)

      return
      end
