!=======================================================================
      subroutine Vmatrix(iterUV,nx,ny,level,ierr,ht,beta,
     &      X,Y,XC,YC,rho,mu,U,V,V5,
     &      BCE,BCW,BCN,BCS,Q2,b)
!=======================================================================
      implicit none
      integer iterUV,nx,ny,level,ierr
      real*8  ht,beta
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny),V(nx,0:ny)
      real*8  V5(5,nx,0:ny)
      real*8  BCE(0:ny,2),BCW(0:ny,2),BCN(0:nx,2),BCS(0:nx,2)
      real*8  Q2(nx,0:ny),b(nx,0:ny)

!---- Output: V5 & b

!---- Local variables

      integer ix,iy,nxm1,nym1,ixm1,ixp1,iym1,iyp1,ix1,iy1
      real*8  rht,dx1,dx2,dx,dy1,dy2,dy
      real*8  zero,half,two,f1,f2
      real*8  me,mw,mn,ms,V1e,V1w,V2n,V2s
      real*8  UE,UW,UN,US,UP,VE,VW,VN,VS,VP
      real*8  rhoe,rhow,rhon,rhos,rhop,mue,muw,mun,mus,mup
      real*8  AE,AW,AN,AS
      real*8  V5E,V5W,V5N,V5S

!---- Local setting

      nxm1=nx-1
      nym1=ny-1
      rht =1.d0/ht
      zero=0.d0
      half=0.5d0
      two=2.d0


!---- Initial setting for "b"

      do iy=0,ny
      do ix=1,nx
         b(ix,iy)=Q2(ix,iy)
      enddo
      enddo

!---- Initial setting for "BC"

      do iy=0,ny,ny
      do ix=1,nx
         V5(1,ix,iy)=0.d0
         V5(2,ix,iy)=0.d0
         V5(3,ix,iy)=1.d0
         V5(4,ix,iy)=0.d0
         V5(5,ix,iy)=0.d0
      enddo
      enddo

!----------------------
!---- Get V5 for "V"
!----------------------

      do iy=1,nym1
         iym1=max(0,iy-1)
         iyp1=min(ny,iy+1)
         iy1=max(iy,1)

         dy1=Y(iy)-YC(iy)
         dy2=YC(iyp1)-Y(iy)
         dy=dy1+dy2
         f1=dy1/dy
         f2=dy2/dy
      do ix=1,nx
         ixm1=max(1,ix-1)
         ixp1=min(nx,ix+1)
         ix1=max(ix,1)
         dx=X(ix)-X(ix-1)

!---- Set Coefficients

         VN=V(ix,iyp1)
         rhon=rho(ix,iyp1)
         mun=mu(ix,iyp1)

         VS=V(ix,iym1)
         rhos=rho(ix,iy1)
         mus=mu(ix,iy1)

         if(ix.eq.nx)then
            VE=BCE(iy,2)
            rhoe=f2*rhos+f1*rhon
            mue=f2*mus+f1*mun
         else
            VE=V(ixp1,iy)
            rhoe=0.25d0*(rhon+rhos+rho(ixp1,iy1)+rho(ixp1,iyp1))
            mue=0.25d0*(mun+mus+mu(ixp1,iy1)+mu(ixp1,iyp1))
         endif

         if(ix.eq.1)then
            VW=BCW(iy,2)
            rhow=f2*rhos+f1*rhon
            muw=f2*mus+f1*mun
         else
            VW=V(ixm1,iy)
            rhow=0.25d0*(rhon+rhos+rho(ixm1,iy1)+rho(ixm1,iyp1))
            muw=0.25d0*(mun+mus+mu(ixm1,iy1)+mu(ixm1,iyp1))
         endif

         VP=V(ix,iy)
         rhop=f2*rhos+f1*rhon
         mup =f2*mus+f1*mun


         V1e=f2*U(ix,iy)+f1*U(ix,iyp1)
         V1w=f2*U(ix-1,iy)+f1*U(ix-1,iyp1)
         V2n=half*(VP+VN)
         V2s=half*(VP+VS)

         me= rhoe*dy*V1e
         mw=-rhow*dy*V1w
         mn= rhon*dx*V2n
         ms=-rhos*dx*V2s


!---- Convective term

         V5E=half*min(me,zero)
         V5W=half*min(mw,zero)
         V5N=half*min(mn,zero)
         V5S=half*min(ms,zero)

         b(ix,iy)=b(ix,iy)+half*beta*(
     &      min(me,zero)*(VE-VP)-me*half*(VP+VE)
     &     +min(mw,zero)*(VW-VP)-mw*half*(VP+VW)
     &     +min(mn,zero)*(VN-VP)-mn*half*(VP+VN)
     &     +min(ms,zero)*(VS-VP)-ms*half*(VP+VS)
     &             )

!---- Diffusive term

         if(ix.eq.nx)then
            AE=mue*dy/(X(ix)-XC(ix))
         else
            AE=mue*dy/(XC(ixp1)-XC(ix))
         endif
         if(ix.eq.1)then
            AW=muw*dy/(XC(ix)-X(ix-1))
         else
            AW=muw*dy/(XC(ix)-XC(ixm1))
         endif
         AN=two*mun*dx/(Y(iyp1)-Y(iy))
         AS=two*mus*dx/(Y(iy)-Y(iym1))

         V5E=V5E-half*AE
         V5W=V5W-half*AW
         V5N=V5N-half*AN
         V5S=V5S-half*AS

         b(ix,iy)=b(ix,iy)+half*(
     &     +mue*(U(ix,iyp1)-U(ix,iy))
     &     -muw*(U(ix-1,iyp1)-U(ix-1,iy))
     &             )

!---- Final assembly

         V5(1,ix,iy)=V5S
         V5(2,ix,iy)=V5W
         V5(3,ix,iy)=rht*(dx*dy)*rhop-(V5S+V5W+V5E+V5N)
         V5(4,ix,iy)=V5E
         V5(5,ix,iy)=V5N


      enddo
      enddo


      return
      end

