!=======================================================================
      subroutine Umatrix(iterUV,nx,ny,level,ierr,ht,beta,
     &      X,Y,XC,YC,rho,mu,U,V,V5,
     &      BCE,BCW,BCN,BCS,Q1,b)
!=======================================================================
      implicit none
      integer iterUV,nx,ny,level,ierr
      real*8  ht,beta
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny),V(nx,0:ny)
      real*8  V5(5,0:nx,ny)
      real*8  BCE(0:ny,2),BCW(0:ny,2),BCN(0:nx,2),BCS(0:nx,2)
      real*8  Q1(0:nx,ny),b(0:nx,ny)

!---- Output: V5 & b

!---- Local variables

      integer ix,iy,nxm1,nym1,ixm1,ixp1,iym1,iyp1,ix1,iy1
      real*8  rht,dx1,dx2,dx,dy1,dy2,dy
      real*8  zero,half,two,f1,f2
      real*8  me,mw,mn,ms,V1e,V1w,V2n,V2s
      real*8  UE,UW,UN,US,UP,VE,VW,VN,VS,VP
      real*8  rhoe,rhow,rhon,rhos,rhop,mue,muw,mun,mus,mup
      real*8  AE,AW,AN,AS
      real*8  V5E,V5W,V5N,V5S

!---- Local setting

      nxm1=nx-1
      nym1=ny-1
      rht =1.d0/ht
      zero=0.d0
      half=0.5d0
      two=2.d0


!---- Initial setting for "b"

      do iy=1,ny
      do ix=0,nx
         b(ix,iy)=Q1(ix,iy)
      enddo
      enddo

!---- Initial setting for "BC"

      do iy=1,ny
      do ix=0,nx,nx
         V5(1,ix,iy)=0.d0
         V5(2,ix,iy)=0.d0
         V5(3,ix,iy)=1.d0
         V5(4,ix,iy)=0.d0
         V5(5,ix,iy)=0.d0
      enddo
      enddo

!----------------------
!---- Get V5 for "U"
!----------------------

      do iy=1,ny
         iym1=max(1,iy-1)
         iyp1=min(ny,iy+1)
         dy=Y(iy)-Y(iy-1)
      do ix=1,nxm1
         ixm1=max(0,ix-1)
         ixp1=min(nx,ix+1)
         ix1=max(ix,1)

         dx1=X(ix)-XC(ix)
         dx2=XC(ixp1)-X(ix)
         dx=dx1+dx2
         f1=dx1/dx
         f2=dx2/dx

!---- Set Coefficients

         UE=U(ixp1,iy)
         rhoe=rho(ixp1,iy)
         mue=mu(ixp1,iy)

         UW=U(ixm1,iy)
         muw=mu(ix1,iy)
         rhow=rho(ix1,iy)

         if(iy.eq.ny)then
            UN=BCN(ix,1)
            rhon=f2*rhow+f1*rhoe
            mun =f2*muw+f1*mue
         else
            UN=U(ix,iyp1)
            rhon=0.25d0*(rhoe+rhow+rho(ix1,iyp1)+rho(ixp1,iyp1))
            mun =0.25d0*(mue+muw+mu(ix1,iyp1)+mu(ixp1,iyp1))
         endif

         if(iy.eq.1)then
            US=BCS(ix,1)
            rhos=f2*rhow+f1*rhoe
            mus =f2*muw+f1*mue
         else
            US=U(ix,iym1)
            rhos=0.25d0*(rhoe+rhow+rho(ix1,iym1)+rho(ixp1,iym1))
            mus =0.25d0*(mue+muw+mu(ix1,iym1)+mu(ixp1,iym1))
         endif

         UP=U(ix,iy)
         rhop=f2*rhow+f1*rhoe
         mup =f2*muw+f1*mue


         V1e=half*(UP+UE)
         V1w=half*(UP+UW)
         V2n=f2*V(ix,iy)+f1*V(ixp1,iy)
         V2s=f2*V(ix,iy-1)+f1*V(ixp1,iy-1)

         me= rhoe*dy*V1e
         mw=-rhow*dy*V1w
         mn= rhon*dx*V2n
         ms=-rhos*dx*V2s


!---- Convective term

         V5E=half*min(me,zero)
         V5W=half*min(mw,zero)
         V5N=half*min(mn,zero)
         V5S=half*min(ms,zero)

         b(ix,iy)=b(ix,iy)+half*beta*(
     &      min(me,zero)*(UE-UP)-me*half*(UP+UE)
     &     +min(mw,zero)*(UW-UP)-mw*half*(UP+UW)
     &     +min(mn,zero)*(UN-UP)-mn*half*(UP+UN)
     &     +min(ms,zero)*(US-UP)-ms*half*(UP+US)
     &             )

!---- Diffusive term

         AE=two*mue*dy/(X(ixp1)-X(ix))
         AW=two*muw*dy/(X(ix)-X(ixm1))
         if(iy.eq.ny)then
            AN=mun*dx/(Y(iy)-YC(iy))
         else
            AN=mun*dx/(YC(iyp1)-YC(iy))
         endif
         if(iy.eq.1)then
            AS=mus*dx/(YC(iy)-Y(iy-1))
         else
            AS=mus*dx/(YC(iy)-YC(iym1))
         endif

         V5E=V5E-half*AE
         V5W=V5W-half*AW
         V5N=V5N-half*AN
         V5S=V5S-half*AS

         b(ix,iy)=b(ix,iy)+half*(
     &     +mun*(V(ixp1,iy)-V(ix,iy))
     &     -mus*(V(ixp1,iy-1)-V(ix,iy-1))
     &             )

!---- Final assembly

         V5(1,ix,iy)=V5S
         V5(2,ix,iy)=V5W
         V5(3,ix,iy)=rht*(dx*dy)*rhop-(V5S+V5W+V5E+V5N)
         V5(4,ix,iy)=V5E
         V5(5,ix,iy)=V5N

      enddo
      enddo


      return
      end

