!=======================================================================
      subroutine step3(it,nx,ny,level,ierr,ht,XC,YC,rho,U,V,P)
!=======================================================================
      implicit none
      integer it,nx,ny,level,ierr
      real*8  ht
      real*8  XC(nx),YC(ny),rho(nx,ny)
      real*8  U(0:nx,ny),V(nx,0:ny),P(nx,ny)

!---- local variables

      integer ix,iy,nxm1,nym1
      real*8  dx,dy,rhoP, half,halfht

!---- Informing: stdout

      if(level.ge.1)then
         print'("STEP3: it=",i5)',it
         if(level.ge.3) print*,"nx=",nx," ny=",ny
      endif

      nxm1=nx-1
      nym1=ny-1

      half=0.5d0
      halfht=0.5d0*ht


!---- Update "U"

      do iy=1,ny
      do ix=1,nxm1
        dx=XC(ix+1)-XC(ix)
        rhoP=half*(rho(ix,iy)+rho(ix+1,iy))
        U(ix,iy)=U(ix,iy)-(halfht/rhoP)*(P(ix+1,iy)-P(ix,iy))/dx
      enddo
      enddo


!---- Update "V"

      do iy=1,nym1
        dy=YC(iy+1)-YC(iy)
      do ix=1,nx
        rhoP=half*(rho(ix,iy)+rho(ix,iy+1))
        V(ix,iy)=V(ix,iy)-(halfht/rhoP)*(P(ix,iy+1)-P(ix,iy))/dy
      enddo
      enddo


      return
      end

