!=======================================================================
      subroutine step2(it,nx,ny,idsol_op,level,ierr,ht,ht0,eta,
     &            XC,YC,rho,U,V,P,P01,P02)
!=======================================================================
      implicit none
      integer it,nx,ny,idsol_op,level,ierr
      real*8  ht,ht0,eta
      real*8  XC(nx),YC(ny),rho(nx,ny)
      real*8  U(0:nx,ny),V(nx,0:ny),P(nx,ny)
      real*8  P01(nx,ny),P02(nx,ny)

!---- local variables

      integer ix,iy,nxm1,nym1
      real*8  dx,dy,rhoP, half,f1,f2

!---- Informing: stdout

      if(level.ge.1)then
         print'("STEP2: it=",i5," eta=",f4.2)',it,eta
         if(level.ge.3) print*,"nx=",nx," ny=",ny
      endif

      nxm1=nx-1
      nym1=ny-1
      half=0.5d0


!---- First, Pressure Setting

      if(it.eq.1 .or. idsol_op.eq.1)then
         do iy=1,ny
         do ix=1,nx
            P(ix,iy)=half*P01(ix,iy)
         enddo
         enddo
      else
         f2=-half*(ht/ht0) *eta
         f1=half-f2
         do iy=1,ny
         do ix=1,nx
            P(ix,iy)=f1*P01(ix,iy)+f2*P02(ix,iy)
         enddo
         enddo
      endif


!---- Update "U^{**}"

      do iy=1,ny
      do ix=1,nxm1
        dx=XC(ix+1)-XC(ix)
        rhoP=half*(rho(ix,iy)+rho(ix+1,iy))
        U(ix,iy)=U(ix,iy)+(ht/rhoP)*(P(ix+1,iy)-P(ix,iy))/dx
      enddo
      enddo


!---- Update "V^{**}"

      do iy=1,nym1
        dy=YC(iy+1)-YC(iy)
      do ix=1,nx
        rhoP=half*(rho(ix,iy)+rho(ix,iy+1))
        V(ix,iy)=V(ix,iy)+(ht/rhoP)*(P(ix,iy+1)-P(ix,iy))/dy
      enddo
      enddo


      return
      end

