!=======================================================================
      subroutine step1(it,nx,ny,idsol_uv,itmax,iterUV,iterSIP,
     &      level,ierr,
     &      ht,alpha,beta,tol,
     &      X,Y,XC,YC,rho,mu,U,V,V5,
     &      BCE,BCW,BCN,BCS,Q1,Q2,b,wksp,ws0)
!=======================================================================
      implicit none
      integer it,nx,ny,idsol_uv,itmax,iterUV,iterSIP,level,ierr
      real*8  ht,alpha,beta,tol
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny),V(nx,0:ny)
      real*8  V5(5*(nx+1)*(ny+1),2)
      real*8  BCE(0:ny,2),BCW(0:ny,2),BCN(0:nx,2),BCS(0:nx,2)
      real*8  Q1(0:nx,ny),Q2(nx,0:ny),b(*)
      real*8  wksp(*),ws0(0:nx,0:ny,2)

!---- Local variables

      integer ix,iy,ilumode,level0,iterST
      real*8  tol_loc,errU,errV
*      real*8  errU0,errV0,l8norm

!---- Informing: stdout

      if(level.ge.1) then
         print'("STEP1: it=",i5," idsol_uv=",i1
     &               ," alpha=",f4.2," beta=",f4.2)',
     &                  it,idsol_uv,alpha,beta
      endif


!---- Local setting

      ilumode=1
      level0=0
      tol_loc=min(1.d-3,dsqrt(tol))
      iterSIP=0

*      errU0=l8norm((nx+1)*ny,U)
*      errV0=l8norm(nx*(ny+1),V)


!========================================
!---- Picard iteration
!========================================

!-----------------------------
      do iterUV=1,itmax
!-----------------------------

!---- Save "U" and "V"

      do iy=1,ny
      do ix=1,nx
         ws0(ix,iy,1)=U(ix,iy)
      enddo
      enddo

      do iy=1,ny
      do ix=1,nx
         ws0(ix,iy,2)=V(ix,iy)
      enddo
      enddo


!---- Get the system for "U"

      call Umatrix(iterUV,nx,ny,level0,ierr,ht,beta,
     &      X,Y,XC,YC,rho,mu,U,V,V5(1,1),
     &      BCE,BCW,BCN,BCS,Q1,b)

!---- Solve for "U"

      if(idsol_uv.eq.1) then

         call sip5(ilumode,(nx+1),ny,itmax,iterST,level0,ierr,
     &          alpha,tol_loc,V5(1,1),V5(1,2),U,b,wksp)

         iterSIP=iterSIP+iterST

      else

         stop 'Error: step1.f: currently, idsol_uv should be 1'

      endif

!---- Get the system for "V"

      call Vmatrix(iterUV,nx,ny,level0,ierr,ht,beta,
     &      X,Y,XC,YC,rho,mu,U,V,V5(1,1),
     &      BCE,BCW,BCN,BCS,Q2,b)

!---- Solve for "V"

      if(idsol_uv.eq.1) then

         call sip5(ilumode,nx,(ny+1),itmax,iterST,level0,ierr,
     &          alpha,tol_loc,V5(1,1),V5(1,2),V,b,wksp)

         iterSIP=iterSIP+iterST

      else

      endif

!---- Check Stopping

      errU=0.d0
      errV=0.d0

      do iy=1,ny
      do ix=1,nx
         errU=max(errU,dabs(ws0(ix,iy,1)-U(ix,iy)))
      enddo
      enddo

      do iy=1,ny
      do ix=1,nx
         errV=max(errV,dabs(ws0(ix,iy,2)-V(ix,iy)))
      enddo
      enddo

      if(max(errU,errV).le.tol) goto 9999
*      if(max((errU/errU0),(errV/errV0)).le.tol) goto 9999

!-----------------------------
      enddo
!-----------------------------

 9999 continue

      if(level.ge.2.and.(it.eq.1.or.mod(it,20).eq.0))then
         print*,"it=",it," iterUV=",iterUV
      endif

      return
      end

