!=======================================================================
      subroutine press(it,nx,ny,idsol_pr,itmax,level,iterP,ierr,
     &             ht,tn,tol,X,Y,rho,U,V,P,P3,P5,b,wksp)
!=======================================================================
      implicit none
      integer it,nx,ny,idsol_pr,itmax,level,iterP,ierr
      real*8  ht,tn,tol
      real*8  X(0:nx),Y(0:ny),rho(nx,ny)
      real*8  U(0:nx,ny),V(nx,0:ny),P(nx,ny)
      real*8  P3(3*nx*ny,2),P5(5*nx*ny,2)
      real*8  b(nx,ny),wksp(2,nx,*)

!---- local variables

      integer ix,iy,iym1,iyp1
      integer level0
      real*8  dx,dy,rhoP,rhoE,rhoW,rhoN,rhoS
      real*8  half,f1

!---- Informing: stdout

      if(level.ge.1)then
         print'("PRESS: it=",i5," idsol_pr=",i1)',it,idsol_pr
         if(level.ge.3) print*,"nx=",nx," ny=",ny," tn=",tn
      endif

      half=0.5d0
      level0=0


!---- Get the right-side.

      f1=-2.d0/ht

      do iy=1,ny
          dy=Y(iy)-Y(iy-1)
          iym1=max(iy-1,1)
          iyp1=min(iy+1,ny)
      do ix=1,nx
          dx=X(ix)-X(ix-1)
          rhoP=rho(ix,iy)
          rhoE=half*(rhoP+rho(min(ix+1,nx),iy))
          rhoW=half*(rhoP+rho(max(ix-1,1 ),iy))
          rhoN=half*(rhoP+rho(ix,iyp1))
          rhoS=half*(rhoP+rho(ix,iym1))

          b(ix,iy)=f1*( dy*(rhoE*U(ix,iy)-rhoW*U(ix-1,iy))
     &                 +dx*(rhoN*V(ix,iy)-rhoS*V(ix,iy-1)) )

      enddo
      enddo


!---- Pressure Initialization
!---- Assumed done earlier

*      do iy=1,ny
*      do ix=1,nx
*          P(ix,iy)=2.d0*P(ix,iy)
*      enddo
*      enddo


!---- Call Poisson solver:

      if(idsol_pr.le.1)then

         if(it.eq.1) call ilu0c(nx,ny,level0,P5,P5(1,2),ierr)

         call pcg_ilu0c(nx,ny,itmax,1,level0,iterP,
     &         P5,P5(1,2),P,b,wksp,tol,ierr)

      else

         stop 'Error: press.f: currently, idsol_pr should be 1'

      endif


      return
      end
