!=======================================================================
      subroutine pmatrix(nx,ny,idPois_Dis,level,ierr,
     &                   DIS,X,Y,XC,YC,P31,P32,P5)
!=======================================================================
      implicit none
      integer nx,ny,idPois_Dis,level,ierr
      real*8 X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8 P31(3,nx,ny),P32(3,ny,nx),P5(5,nx,ny,*)
      character*5 DIS

      integer ix,iy,k,nxm1,nym1
      real*8 dx,dy,area,c1,c2

      if(level.ge.1) then
          print'("PMATRIX: ",a3," nx=",i3," ny=",i3)',DIS,nx,ny
      endif

      nxm1=nx-1
      nym1=ny-1

!---- Here we construct directional matrices for "-P_{xx}-P_{yy}"
!---- by utilizing the cell-centered finite volume method.
!---- The directional construction would be useful for
!---- some iterative algorithms that we will try later.

      goto(1000,2000),idPois_Dis

!----------------------------
 1000 continue   !! FVM
!----------------------------

!---- First, make "P31" for the horizontal direction of FVM:

      do iy=1,ny

         dy=Y(iy)-Y(iy-1)

         ix=1
            c2=XC(ix+1)-XC(ix)
            P31(1,ix,iy)=0.d0
            P31(3,ix,iy)=-dy/c2
            P31(2,ix,iy)=-(P31(1,ix,iy)+P31(3,ix,iy))

         do ix=2,nxm1
            c1=c2
            c2=XC(ix+1)-XC(ix)
            P31(1,ix,iy)=-dy/c1
            P31(3,ix,iy)=-dy/c2
            P31(2,ix,iy)=-(P31(1,ix,iy)+P31(3,ix,iy))
         enddo

         ix=nx
            c1=c2
            P31(1,ix,iy)=-dy/c1
            P31(3,ix,iy)=0.d0
            P31(2,ix,iy)=-(P31(1,ix,iy)+P31(3,ix,iy))
      enddo


!---- Secondly, make "P32" for the vertical direction of FVM:

      do ix=1,nx

         dx=X(ix)-X(ix-1)

         iy=1
            c2=YC(iy+1)-YC(iy)
            P32(1,iy,ix)=0.d0
            P32(3,iy,ix)=-dx/c2
            P32(2,iy,ix)=-(P32(1,iy,ix)+P32(3,iy,ix))

         do iy=2,nym1
            c1=c2
            c2=YC(iy+1)-YC(iy)
            P32(1,iy,ix)=-dx/c1
            P32(3,iy,ix)=-dx/c2
            P32(2,iy,ix)=-(P32(1,iy,ix)+P32(3,iy,ix))
         enddo

         iy=ny
            c1=c2
            P32(1,iy,ix)=-dx/c1
            P32(3,iy,ix)=0.d0
            P32(2,iy,ix)=-(P32(1,iy,ix)+P32(3,iy,ix))
      enddo

      goto 3000

!----------------------------
 2000 continue   !! FDM
!----------------------------

!---- First, make "P31" for the horizontal direction of FDM:

      do iy=1,ny

         dy=Y(iy)-Y(iy-1)

         ix=1
            dx=X(ix)-X(ix-1)
            area=dx*dy
*            c2=(0.5d0*(XC(ix)+XC(ix+1))-X(ix-1))*(XC(ix+1)-XC(ix))
*            c2=(XC(ix+1)-XC(ix))**2
            c2=dx*(XC(ix+1)-XC(ix))
            P31(1,ix,iy)=0.d0
            P31(3,ix,iy)=-area/c2
            P31(2,ix,iy)=-(P31(1,ix,iy)+P31(3,ix,iy))

         do ix=2,nxm1
            area=(X(ix)-X(ix-1))*dy
            c1=0.5*(XC(ix+1)-XC(ix-1))*(XC(ix)-XC(ix-1))
            c2=0.5*(XC(ix+1)-XC(ix-1))*(XC(ix+1)-XC(ix))
            P31(1,ix,iy)=-area/c1
            P31(3,ix,iy)=-area/c2
            P31(2,ix,iy)=-(P31(1,ix,iy)+P31(3,ix,iy))
         enddo

         ix=nx
            dx=X(ix)-X(ix-1)
            area=dx*dy
*            c1=(X(ix)-0.5d0*(XC(ix-1)+XC(ix)))*(XC(ix)-XC(ix-1))
*            c1=(XC(ix)-XC(ix-1))**2
            c1=dx*(XC(ix)-XC(ix-1))
            P31(1,ix,iy)=-area/c1
            P31(3,ix,iy)=0.d0
            P31(2,ix,iy)=-(P31(1,ix,iy)+P31(3,ix,iy))
      enddo

!---- Secondly, make "P32" for the vertical direction of FDM:

      do ix=1,nx

         dx=X(ix)-X(ix-1)

         iy=1
            dy=Y(iy)-Y(iy-1)
            area=dx*dy
*            c2=(0.5d0*(YC(iy)+YC(iy+1))-Y(iy-1))*(YC(iy+1)-YC(iy))
*            c2=(YC(iy+1)-YC(iy))**2
            c2=dy*(YC(iy+1)-YC(iy))
            P32(1,iy,ix)=0.d0
            P32(3,iy,ix)=-area/c2
            P32(2,iy,ix)=-(P32(1,iy,ix)+P32(3,iy,ix))

         do iy=2,nym1
            area=dx*(Y(iy)-Y(iy-1))
            c1=0.5*(YC(iy+1)-YC(iy-1))*(YC(iy)-YC(iy-1))
            c2=0.5*(YC(iy+1)-YC(iy-1))*(YC(iy+1)-YC(iy))
            P32(1,iy,ix)=-area/c1
            P32(3,iy,ix)=-area/c2
            P32(2,iy,ix)=-(P32(1,iy,ix)+P32(3,iy,ix))
         enddo

         iy=ny
            dy=Y(iy)-Y(iy-1)
            area=dx*dy
*            c1=(Y(iy)-0.5d0*(YC(iy-1)+YC(iy)))*(YC(iy)-YC(iy-1))
*            c1=(YC(iy)-YC(iy-1))**2
            c1=dy*(YC(iy)-YC(iy-1))
            P32(1,iy,ix)=-area/c1
            P32(3,iy,ix)=0.d0
            P32(2,iy,ix)=-(P32(1,iy,ix)+P32(3,iy,ix))
      enddo


 3000 continue

!---- Now, combine them for "P5":

      do iy=1,ny
      do ix=1,nx
         P5(1,ix,iy,1)=P32(1,iy,ix)
         P5(2,ix,iy,1)=P31(1,ix,iy)
         P5(3,ix,iy,1)=P31(2,ix,iy)+P32(2,iy,ix)
         P5(4,ix,iy,1)=P31(3,ix,iy)
         P5(5,ix,iy,1)=P32(3,iy,ix)
      enddo
      enddo


!---- Well, let us fix the pressure at the corner (ax,ay):

      ix=1
      iy=1
         P5(1,ix,iy,1)=0.d0
         P5(2,ix,iy,1)=0.d0
         P5(3,ix,iy,1)=1.d0
         P5(4,ix,iy,1)=0.d0
         P5(5,ix,iy,1)=0.d0

      return
      end

