!=======================================================================
      subroutine opersplit(nt,nx,ny,id_Steady,id_BC,auto_dt,level,ierr,
     &       idsol_op,idsol_uv,idsol_pr,itmax,
     &       density,visco,vlid,tn,
     &       at,bt,ax,bx,ay,by,grid_fac,alpha,beta,eta,tol,
     &       X,Y,XC,YC,rho,mu,U,V,P,
     &       V5,P3,P5,BCE,BCW,BCN,BCS,
     &       Q1,Q2,b,P0,wksp,ws0)
!=======================================================================
      implicit none
      integer nt,nx,ny,id_Steady,id_BC,auto_dt,level,ierr
      integer idsol_op,idsol_uv,idsol_pr,itmax
      real*8  density,visco,vlid,tn
      real*8  at,bt,ax,bx,ay,by,grid_fac,alpha,beta,eta,tol
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny,*),V(nx,0:ny),P(nx,ny)
      real*8  V5(5*(nx+1)*(ny+1),2),P3(3*nx*ny,2),P5(5*nx*ny,2)
      real*8  BCE(0:ny,2),BCW(0:ny,2),BCN(0:nx,2),BCS(0:nx,2)
      real*8  Q1(0:nx,ny),Q2(nx,0:ny),b((nx+1)*(ny+1))
      real*8  P0(nx,ny,2),wksp(0:nx,0:ny),ws0(nx,ny)

!---- Local variables

      integer it,ix,iy,ipx,nxm1,nym1
      integer nt_max,iterUV,iterSIP,iterP
      integer iterUV_tot,iterSIP_tot,iterP_tot
      integer id1,id2,level0,id_check,ipdur,jumpU
      real*8  ht,ht0,bt_eps,tol_Steady,change_U,zero,U_bot
      real*8  halfdx,halfdy
      character*40 file

!---- Local checking and setting:

      if(ierr.ne.0) then
         print*,"Error: opersplit.f: at beginning"
         return
      endif

      if(auto_dt.eq.1)then
         stop 'Error: opersplit.f: Currently, auto_dt should be 0.'
         nt_max=1000000
      else
         nt_max=nt
         ht=(bt-at)/dble(nt)
         ht0=ht
      endif

      zero=0.d0
      tn=at
      bt_eps=bt+1.d-10
      tol_Steady=1.E-6   ! in L8-norm.

      iterUV_tot=0
      iterSIP_tot=0
      iterP_tot=0

      level0=0
      id_check=0
      jumpU=4
      nxm1=nx-1
      nym1=ny-1

      if(nt.le.500)then
         ipdur=20
      else if(nt.le.1000)then
         ipdur=50
      else
         ipdur=100
      endif


!---- Informing: stdout

      if(level.ge.1) print'("OPERSPLIT: idsol_op=",i1,
     &               " idsol_uv=",i1," idsol_pr=",i1)',
     &               idsol_op,idsol_uv,idsol_pr
      if(level.ge.2) then
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"nx=",nx," ax=",ax," bx=",bx
         print*,"ny=",ny," ay=",ay," by=",by
         print*,"density=",density," visco=",visco," vlid=",vlid
         print*,"id_Steady=",id_Steady," id_BC=",id_BC
     &         ," auto_dt=",auto_dt," grid_fac=",grid_fac
         print*,"alpha=",alpha," beta=",beta," eta=",eta," tol=",tol
      endif

      if(level.ge.1)then
          print*,"******************************************"
          print*,"* The Gravity Effect Is Not Yet Included *"
          print*,"******************************************"
      endif

      if(level.ge.1 .and. id_Steady.eq.1)then
          print*,"******************************************"
          print*,"*   The Soultion Feature: Steady-State   *"
          print'(" *   tol_Steady=",1pe7.1,19x,"*")',tol_Steady
          print*,"******************************************"
      endif


!=============================
!---- The main comes here.
!=============================

!---------------------------------
      do it=1,nt_max
!---------------------------------

      if(mod(it,ipdur).eq.0 .or. it.eq.nt_max) then
         level0=level-1
         if(level0.eq.0) print*,"it=",it
      endif

!---- Dynamic setting for "ht":

!      if(auto_dt.eq.1)then
!         (Not yet considered)
!      endif


!---- Setting for the current time level:

      tn=tn+ht
      if(tn.gt.bt_eps) goto 9999

      id1=mod(it+1,2)+1
      id2=mod(it,  2)+1


!---- Get "Q1" and "Q2":

      call getQnm1(it,nx,ny,idsol_op,level0,ht,ht0,beta,eta,
     &      X,Y,XC,YC,rho,mu,U,V,P,
     &      BCE,BCW,BCN,BCS,Q1,Q2,P0(1,1,id1),P0(1,1,id2))


!---- Set BC in the new level

      if(id_BC.eq.2) then
          U_bot=vlid*min(1.d0,0.1*tn)
          call getBC(id_BC,nx,ny,level0,ierr,
     &              zero,zero,zero,zero,U_bot,zero,vlid,zero,
     &              BCE,BCW,BCN,BCS)
      endif


!---- Step 1: Solve for "U^{*}" & "V^{*}"

      call step1(it,nx,ny,idsol_uv,itmax,iterUV,iterSIP,
     &      level0,ierr,
     &      ht,alpha,beta,tol,
     &      X,Y,XC,YC,rho,mu,U,V,V5,
     &      BCE,BCW,BCN,BCS,Q1,Q2,b,wksp,ws0)
          
      iterUV_tot=iterUV_tot+iterUV
      iterSIP_tot=iterSIP_tot+iterSIP


!---- Step 2: Solve for "U^{**}" & "V^{**}"

      call step2(it,nx,ny,idsol_op,level0,ierr,ht,ht0,eta,
     &            XC,YC,rho,U,V,P,P0(1,1,id1),P0(1,1,id2))


!---- Step 3: Solve for "P";  Update "U^{n}" & "V^{n}"

      do iy=1,ny
      do ix=1,nx
*         P(ix,iy)=2.d0*P(ix,iy)
         P(ix,iy)=2.d0*P0(ix,iy,id1)-P0(ix,iy,id2)
      enddo
      enddo

      call press(it,nx,ny,idsol_pr,itmax,level0,iterP,ierr,
     &           ht,tn,tol,X,Y,rho,U,V,P,P3,P5,b,wksp)

      iterP_tot=iterP_tot+iterP

      call step3(it,nx,ny,level0,ierr,ht,XC,YC,rho,U,V,P)


!---- Save "P" and "ht" for the next time step

      do iy=1,ny
      do ix=1,nx
         P0(ix,iy,id2)=P(ix,iy)
      enddo
      enddo

      ht0=ht
      level0=0


!---- Do extra work for accuracy improvement when it=1 && idsol_op=2
!---- First, modify Q=Q+0.5*(Dp^0-Dp^1)
!---- Then, do step1 with the modified Q

      if(it.eq.1 .and. idsol_op.eq.2)then

          do iy=1,ny
          halfdy=0.5d0*(Y(iy)-Y(iy-1))
          do ix=1,nxm1
              Q1(ix,iy)=Q1(ix,iy)+halfdy*(
     &              P0(ix+1,iy,id1)-P0(ix,iy,id1)
     &             -P0(ix+1,iy,id2)+P0(ix,iy,id2) )
          enddo
          enddo

          do iy=1,nym1
          do ix=1,nx
              halfdx=0.5d0*(X(ix)-X(ix-1))
              Q2(ix,iy)=Q2(ix,iy)+halfdx*(
     &              P0(ix,iy+1,id1)-P0(ix,iy,id1)
     &             -P0(ix,iy+1,id2)+P0(ix,iy,id2) )
          enddo
          enddo

          call step1(it,nx,ny,idsol_uv,itmax,iterUV,iterSIP,
     &          level0,ierr,
     &          ht,alpha,beta,tol,
     &          X,Y,XC,YC,rho,mu,U,V,V5,
     &          BCE,BCW,BCN,BCS,Q1,Q2,b,wksp,ws0)
          
          iterUV_tot=iterUV_tot+iterUV
          iterSIP_tot=iterSIP_tot+iterSIP

      endif


!---- Check convergence, when id_Steady=1
!---- Below, the checking is performed each 10 timesteps in early stage.

      if(id_Steady.eq.1)then

          id_check=id_check+1

          if(id_check.ge.10)then
             change_U=0.d0
             do iy=1,ny,jumpU
             do ix=1,nx,jumpU
                change_U=max(change_U,dabs(U(ix,iy,1)-U(ix,iy,2)))
             enddo
             enddo
             if(change_U.le.tol_Steady)then
                if(level.ge.1)then
                    print*,"* Solution is steady"
                    print*,"* @ it=",it
                    print*,"* @ tn=",tn
                endif
                goto 9999
             elseif(change_U.gt.(2.*tol_Steady))then
                id_check=0
             endif
          endif

          if(id_check.ge.9)then
             do iy=1,ny,jumpU
             do ix=1,nx,jumpU
                U(ix,iy,2)=U(ix,iy,1)
             enddo
             enddo
          endif

      endif

!---------------------------------
      enddo
!---------------------------------


 9999 continue

!---- Final Print out

      if(level.ge.1)then

         print'("OPERSPLIT:")'
         print*,"iterUV_tot =",iterUV_tot
         print*,"iterSIP_tot=",iterSIP_tot
         print*,"iterP_tot  =",iterP_tot

         ipx=nx/2
         if(id_BC.eq.2) ipx=(nx*4)/5
         print*,"ipx=",ipx

         file="fort.X"
         call fwrite(file,(nx+1),X,ierr)


         file="fort.Y"
         call fwrite(file,(ny+1),Y,ierr)


         file="fort.Unt"
         do iy=1,ny-1
         do ix=0,nx
             wksp(ix,iy)=0.5d0*(U(ix,iy,1)+U(ix,iy+1,1))
         enddo
         enddo
         do ix=0,nx
            wksp(ix,0)=U(ix,1,1)
            wksp(ix,ny)=U(ix,ny,1)
         enddo
         call fwrite(file,(nx+1)*(ny+1),wksp,ierr)


         file="fort.U_vertical"
         do iy=0,ny
            b(iy+1)=wksp(ipx,iy)
         enddo
         call fwrite(file,(ny+1),b,ierr)
         

         file="fort.Vnt"
         do iy=0,ny
         do ix=1,nx-1
             wksp(ix,iy)=0.5d0*(V(ix,iy)+V(ix+1,iy))
         enddo
         enddo
         do iy=0,ny
            wksp(0,iy)=V(1,iy)
            wksp(nx,iy)=V(nx,iy)
         enddo
         call fwrite(file,(nx+1)*(ny+1),wksp,ierr)


         file="fort.V_vertical"
         do iy=0,ny
            b(iy+1)=wksp(ipx,iy)
         enddo
         call fwrite(file,(ny+1),b,ierr)


         file="fort.Pnt"
         call fwrite(file,nx*ny,P,ierr)


         file="fort.DIVnt"
         do iy=1,ny
         do ix=1,nx
            ws0(ix,iy)=(rho(ix,iy)*U(ix,iy,1)
     &                 -rho(ix-1,iy)*U(ix-1,iy,1))/(X(ix)-X(ix-1))
     &                +(rho(ix,iy)*V(ix,iy)
     &                 -rho(ix,iy-1)*V(ix,iy-1))/(Y(iy)-Y(iy-1))
         enddo
         enddo
         call fwrite(file,nx*ny,ws0,ierr)

      endif

      return
      end

