!=======================================================================
      subroutine init(nx,ny,level,ierr,density,visco,vlid,
     &                X,Y,XC,YC,rho,mu,U,V,P,Q1,Q2,P0)
!=======================================================================
      implicit none
      integer nx,ny,level,ierr
      real*8  density,visco,vlid
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny),V(nx,0:ny),P(nx,ny)
      real*8  Q1(0:nx,ny),Q2(nx,0:ny),P0(nx,ny,2)

      integer ix,iy,k

      if(level.ge.1) print'("INIT: nx=",i3," ny=",i3)',nx,ny
      if(level.ge.2)then
         print*,"density=",density," visco=",visco," vlid=",vlid
      endif


!---- Save ("XC","YC"): the midpoints of cells

      do ix=1,nx
         XC(ix)=0.5d0*(X(ix-1)+X(ix))
      enddo

      do iy=1,ny
         YC(iy)=0.5d0*(Y(iy-1)+Y(iy))
      enddo


!---- Set "rho": the density (=constant)

      do iy=1,ny
      do ix=1,nx
         rho(ix,iy)=density
      enddo
      enddo


!---- Set "mu": the viscosity (=constant)

      do iy=1,ny
      do ix=1,nx
         mu(ix,iy)=visco
      enddo
      enddo


!---- Set "U" and "V": the velocity (no moving)

      do iy=1,ny
      do ix=0,nx
         U(ix,iy)=0.d0
      enddo
      enddo

      do iy=0,ny
      do ix=1,nx
         V(ix,iy)=0.d0
      enddo
      enddo


!---- Set "P": the pressure (=constant)

      do iy=1,ny
      do ix=1,nx
         P(ix,iy)=0.d0
      enddo
      enddo


!---- Set "Q1" and "Q1": Zero

      do iy=1,ny
      do ix=0,nx
         Q1(ix,iy)=0.d0
      enddo
      enddo

      do iy=0,ny
      do ix=1,nx
         Q2(ix,iy)=0.d0
      enddo
      enddo


!---- Set "P0" = P

      do k=1,2
      do iy=1,ny
      do ix=1,nx
         P0(ix,iy,k)=P(ix,iy)
      enddo
      enddo
      enddo


      return
      end

