!=======================================================================
      subroutine grid2(nx,ny,level,ierr, ax,bx,ay,by,grid_fac,
     &                 hxmin,hxmax,hymin,hymax,X,Y)
!=======================================================================
      implicit none
      integer nx,ny,level,ierr
      real*8  ax,bx,ay,by,grid_fac,hxmin,hxmax,hymin,hymax
      real*8  X(0:nx),Y(0:ny)

      integer ix,iy
      real*8  eps,hx,hy

      eps=1.d-8

!---- Informing: stdout

      if(level.ge.1) print'("GRID2: grid_fac=",f4.2)',grid_fac
      if(level.ge.2) then
         print*,"nx=",nx," ax=",ax," bx=",bx
         print*,"ny=",ny," ay=",ay," by=",by
      endif

      if(grid_fac.le.(1.d0-eps)) stop 'grid2.f: choose grid_fac >= 1.0'
      if(((nx/2)*2).ne.nx)       stop 'grid2.f: nx should be even'
      if(((ny/2)*2).ne.ny)       stop 'grid2.f: ny should be even'


!---- GRID GENERATION


      if((grid_fac-1.d0).le.eps)then
!---- Uniform case

         hx=(bx-ax)/dble(nx)
         hy=(by-ay)/dble(ny)
         do ix=0,nx
            X(ix)=ax+dble(ix)*hx
         enddo
         do iy=0,ny
            Y(iy)=ay+dble(iy)*hy
         enddo

         hxmin=hx
         hxmax=hx
         hymin=hy
         hymax=hy

      else
!---- General case

         call grid0(nx,ax,bx,grid_fac,hxmin,hxmax,X)
         call grid0(ny,ay,by,grid_fac,hymin,hymax,Y)

      endif


!---- PRINT OUT

      if(level.ge.2) then

         open(68,file="fort.gridX")
            do ix=0,nx
               write(68,*) X(ix)
            enddo
         close(68)

         open(68,file="fort.gridY")
            do iy=0,ny
               write(68,*) Y(iy)
            enddo
         close(68)

      endif

      return
      end

!=======================================================================
      subroutine grid0(nx,ax,bx,grid_fac,hxmin,hxmax,X)
!=======================================================================
      implicit none
      integer nx
      real*8  ax,bx,grid_fac,hxmin,hxmax
      real*8  X(0:nx)

      integer m,i
      real*8  h1,b

!---- begin

      m=nx/2
      b=0.5d0*(bx-ax)

      h1=b*(grid_fac-1.d0)/(grid_fac**m-1.d0)
      hxmin=h1

      X(0) =ax
      X(m) =b
      X(nx)=bx

      do i=1,m-1
         X(i)=X(i-1)+h1
         X(nx-i)=X(nx-i+1)-h1
         h1=h1*grid_fac
      enddo
      
      hxmax=h1*grid_fac


      return
      end

