!=======================================================================
      subroutine getQnm1(it,nx,ny,idsol_op,level,ht,ht0,beta,eta,
     &        X,Y,XC,YC,rho,mu,U,V,P,
     &        BCE,BCW,BCN,BCS,Q1,Q2,P01,P02)
!=======================================================================
      implicit none
      integer it,nx,ny,idsol_op,level
      real*8  ht,ht0,beta,eta
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny),V(nx,0:ny),P(nx,ny)
      real*8  BCE(0:ny,2),BCW(0:ny,2),BCN(0:nx,2),BCS(0:nx,2)
      real*8  Q1(0:nx,ny),Q2(nx,0:ny),P01(nx,ny),P02(nx,ny)

!---- Local variables

      integer ix,iy,nxm1,nym1,ixm1,ixp1,iym1,iyp1,ix1,iy1
      real*8  rht,dx1,dx2,dx,dy1,dy2,dy
      real*8  zero,half,two,f1,f2,omb
      real*8  me,mw,mn,ms,V1e,V1w,V2n,V2s
      real*8  UE,UW,UN,US,UP,VE,VW,VN,VS,VP
      real*8  rhoe,rhow,rhon,rhos,rhop,mue,muw,mun,mus,mup
      real*8  AE,AW,AN,AS,AP

!---- Local setting

      nxm1=nx-1
      nym1=ny-1
      rht =1.d0/ht
      zero=0.d0
      half=0.5d0
      two=2.d0
      omb=1.d0-beta

!---- Informing: stdout

      if(level.ge.1)then
         print'("GETQNM1: it=",i5," idsol_op=",i1)',it,idsol_op
      endif

!---- Pressure Setting

      if(it.eq.1 .or. idsol_op.eq.1)then
         do iy=1,ny
         do ix=1,nx
            P(ix,iy)=P01(ix,iy)
         enddo
         enddo
      else
         f2=-half*(ht/ht0) *eta
         f1=1.d0-f2
         do iy=1,ny
         do ix=1,nx
            P(ix,iy)=f1*P01(ix,iy)+f2*P02(ix,iy)
         enddo
         enddo
      endif


!----------------------
!---- Get Q_1:
!----------------------

      do iy=1,ny
         iym1=max(1,iy-1)
         iyp1=min(ny,iy+1)
         dy=Y(iy)-Y(iy-1)
      do ix=1,nxm1
         ixm1=max(0,ix-1)
         ixp1=min(nx,ix+1)
         ix1=max(ix,1)

         dx1=X(ix)-XC(ix)
         dx2=XC(ixp1)-X(ix)
         dx=dx1+dx2
         f1=dx1/dx
         f2=dx2/dx

!---- Set Coefficients

         UE=U(ixp1,iy)
         rhoe=rho(ixp1,iy)
         mue=mu(ixp1,iy)

         UW=U(ixm1,iy)
         muw=mu(ix1,iy)
         rhow=rho(ix1,iy)

         if(iy.eq.ny)then
            UN=BCN(ix,1)
            rhon=f2*rhow+f1*rhoe
            mun =f2*muw+f1*mue
         else
            UN=U(ix,iyp1)
            rhon=0.25d0*(rhoe+rhow+rho(ix1,iyp1)+rho(ixp1,iyp1))
            mun =0.25d0*(mue+muw+mu(ix1,iyp1)+mu(ixp1,iyp1))
         endif

         if(iy.eq.1)then
            US=BCS(ix,1)
            rhos=f2*rhow+f1*rhoe
            mus =f2*muw+f1*mue
         else
            US=U(ix,iym1)
            rhos=0.25d0*(rhoe+rhow+rho(ix1,iym1)+rho(ixp1,iym1))
            mus =0.25d0*(mue+muw+mu(ix1,iym1)+mu(ixp1,iym1))
         endif

         UP=U(ix,iy)
         rhop=f2*rhow+f1*rhoe
         mup =f2*muw+f1*mue


         V1e=half*(UP+UE)
         V1w=half*(UP+UW)
         V2n=f2*V(ix,iy)+f1*V(ixp1,iy)
         V2s=f2*V(ix,iy-1)+f1*V(ixp1,iy-1)

         me= rhoe*dy*V1e
         mw=-rhow*dy*V1w
         mn= rhon*dx*V2n
         ms=-rhos*dx*V2s

!---- Time-discretization

         Q1(ix,iy)=rht*(dx*dy)*rhop*UP

!---- Convective term

         Q1(ix,iy)=Q1(ix,iy)-half*(
     &      omb*min(me,zero)*(UE-UP) +beta*me*half*(UP+UE)
     &     +omb*min(mw,zero)*(UW-UP) +beta*mw*half*(UP+UW)
     &     +omb*min(mn,zero)*(UN-UP) +beta*mn*half*(UP+UN)
     &     +omb*min(ms,zero)*(US-UP) +beta*ms*half*(UP+US)
     &             )

!---- Diffusive term

         AE=two*mue*dy/(X(ixp1)-X(ix))
         AW=two*muw*dy/(X(ix)-X(ixm1))
         if(iy.eq.ny)then
            AN=mun*dx/(Y(iy)-YC(iy))
         else
            AN=mun*dx/(YC(iyp1)-YC(iy))
         endif
         if(iy.eq.1)then
            AS=mus*dx/(YC(iy)-Y(iy-1))
         else
            AS=mus*dx/(YC(iy)-YC(iym1))
         endif
         AP=-(AE+AW+AN+AS)

         Q1(ix,iy)=Q1(ix,iy)+half*(
     &      AE*UE+AW*UW+AN*UN+AS*US+AP*UP
     &     +mun*(V(ixp1,iy)-V(ix,iy))
     &     -mus*(V(ixp1,iy-1)-V(ix,iy-1))
     &             )

!---- Pressure term

         Q1(ix,iy)=Q1(ix,iy)+dy*(P(ix,iy)-P(ixp1,iy))

      enddo
      enddo

!---- Gravity effect


!----------------------
!---- Get Q_2:
!----------------------

      do iy=1,nym1
         iym1=max(0,iy-1)
         iyp1=min(ny,iy+1)
         iy1=max(iy,1)

         dy1=Y(iy)-YC(iy)
         dy2=YC(iyp1)-Y(iy)
         dy=dy1+dy2
         f1=dy1/dy
         f2=dy2/dy
      do ix=1,nx
         ixm1=max(1,ix-1)
         ixp1=min(nx,ix+1)
         ix1=max(ix,1)
         dx=X(ix)-X(ix-1)

!---- Set Coefficients

         VN=V(ix,iyp1)
         rhon=rho(ix,iyp1)
         mun=mu(ix,iyp1)

         VS=V(ix,iym1)
         rhos=rho(ix,iy1)
         mus=mu(ix,iy1)

         if(ix.eq.nx)then
            VE=BCE(iy,2)
            rhoe=f2*rhos+f1*rhon
            mue=f2*mus+f1*mun
         else
            VE=V(ixp1,iy)
            rhoe=0.25d0*(rhon+rhos+rho(ixp1,iy1)+rho(ixp1,iyp1))
            mue=0.25d0*(mun+mus+mu(ixp1,iy1)+mu(ixp1,iyp1))
         endif

         if(ix.eq.1)then
            VW=BCW(iy,2)
            rhow=f2*rhos+f1*rhon
            muw=f2*mus+f1*mun
         else
            VW=V(ixm1,iy)
            rhow=0.25d0*(rhon+rhos+rho(ixm1,iy1)+rho(ixm1,iyp1))
            muw=0.25d0*(mun+mus+mu(ixm1,iy1)+mu(ixm1,iyp1))
         endif

         VP=V(ix,iy)
         rhop=f2*rhos+f1*rhon
         mup =f2*mus+f1*mun


         V1e=f2*U(ix,iy)+f1*U(ix,iyp1)
         V1w=f2*U(ix-1,iy)+f1*U(ix-1,iyp1)
         V2n=half*(VP+VN)
         V2s=half*(VP+VS)

         me= rhoe*dy*V1e
         mw=-rhow*dy*V1w
         mn= rhon*dx*V2n
         ms=-rhos*dx*V2s

!---- Time-discretization

         Q2(ix,iy)=rht*(dx*dy)*rhop*VP

!---- Convective term

         Q2(ix,iy)=Q2(ix,iy)-half*(
     &      omb*min(me,zero)*(VE-VP) +beta*me*half*(VP+VE)
     &     +omb*min(mw,zero)*(VW-VP) +beta*mw*half*(VP+VW)
     &     +omb*min(mn,zero)*(VN-VP) +beta*mn*half*(VP+VN)
     &     +omb*min(ms,zero)*(VS-VP) +beta*ms*half*(VP+VS)
     &             )

!---- Diffusive term

         if(ix.eq.nx)then
            AE=mue*dy/(X(ix)-XC(ix))
         else
            AE=mue*dy/(XC(ixp1)-XC(ix))
         endif
         if(ix.eq.1)then
            AW=muw*dy/(XC(ix)-X(ix-1))
         else
            AW=muw*dy/(XC(ix)-XC(ixm1))
         endif
         AN=two*mun*dx/(Y(iyp1)-Y(iy))
         AS=two*mus*dx/(Y(iy)-Y(iym1))
         AP=-(AE+AW+AN+AS)

         Q2(ix,iy)=Q2(ix,iy)+half*(
     &      AE*VE+AW*VW+AN*VN+AS*VS+AP*VP
     &     +mue*(U(ix,iyp1)-U(ix,iy))
     &     -muw*(U(ix-1,iyp1)-U(ix-1,iy))
     &             )

!---- Pressure term

         Q2(ix,iy)=Q2(ix,iy)+dx*(P(ix,iy)-P(ix,iyp1))

      enddo
      enddo

!---- Gravity effect


      return
      end

