!=======================================================================
      subroutine driver(nt,nx,ny,id_Steady,id_BC,auto_dt,level,ierr,
     &       idsol_op,idsol_uv,idsol_pr,idPois_Dis,itmax,
     &       density,visco,vlid,
     &       at,bt,ax,bx,ay,by,grid_fac,alpha,beta,eta,tol,
     &       X,Y,XC,YC,rho,mu,U,V,P,
     &       V5,P3,P5,BCE,BCW,BCN,BCS,
     &       Q1,Q2,b,P0,wksp,ws0)
!=======================================================================
      implicit none
      integer nt,nx,ny,id_Steady,id_BC,auto_dt,level,ierr
      integer idsol_op,idsol_uv,idsol_pr,idPois_Dis,itmax
      real*8  density,visco,vlid
      real*8  at,bt,ax,bx,ay,by,grid_fac,alpha,beta,eta,tol
      real*8  X(0:nx),Y(0:ny),XC(nx),YC(ny)
      real*8  rho(nx,ny),mu(nx,ny),U(0:nx,ny),V(nx,0:ny),P(nx,ny)
      real*8  V5(5*(nx+1)*(ny+1),2),P3(3*nx*ny,2),P5(5*nx*ny,2)
      real*8  BCE(0:ny,2),BCW(0:ny,2),BCN(0:nx,2),BCS(0:nx,2)
      real*8  Q1(0:nx,ny),Q2(nx,0:ny),b((nx+1)*(ny+1))
      real*8  P0(nx,ny,2),wksp(*),ws0(*)

!-----------------------------------------------------------------------
! NS_OperSplit, Ver.1.0:  Sun 10/30,2000
! NS_OperSplit, Ver.1.1:  Sun 11/08,2000
! The programmer:         Seongjai Kim, skim@ms.uky.edu
!-----------------------------------------------------------------------
! nt: the number of time levels when "auto_dt=0"
! nx: the number of cells in "x" direction
! ny: the number of cells in "y" direction
! auto_dt  =0: choose the fixed "dt" (ht=(bt-at)/nt)
!          =1: determine "dt" dynamically (not yet implemented)
! level (.ge.0): the printout level
! ierr  (.ge.0): the error indicator; okay only if ierr=0
! idsol_op =1: the operator splitting method of Choi-Moin-Kim
!          =2: our new operator splitting method of better accuracy
! idsol_uv =1: the velocity solver: Stone's SIP method
! idsol_pr =1: the pressure solver: PCG-ILU
! id_Steady =1: The solution represents a steady-state phenomenon.
! id_BC =1: the cavity problem
!       =2: the cavity problem,
!           with bottom velocity increase: v1=vlid*min(1,0.1*t)
! idPois_Dis =1: the Poisson discretizer: FVM
!            =2: the Poisson discretizer: FDM
! itmax: the maximum number of iterations for all iterative solvers
! density: the constant density (=rho)
! visco:   the constant viscosity (=mu)
! vlid:    the lid velocity on the north boundary (=BCN)
! grid_fac (=1.2): the expansion factor for grid generation
! alpha (=0.92): the stabilization parameter for the Stone's algorithm
! beta (=0.5): the blending factor of UDS(=0) and CDS(=1) for convection
! eta (=1/3~0.5): the blending factor for the New OperSplit
! tol (=1.e-7): the tolerance for solvers for velocity and pressure
! U(0:nx,ny): the array for "U"
! V(nx,0:ny): the array for "V"
! P(nx,ny):   the array for "P"
! V5(*,1): the matrix for the velocity components "U" and "V"
! V5(*,2): to be used for "ILU" matrix of "V5(*,1)"
! P5(5*nx*ny,1):   the matrix for the pressure
! P5(5*nx*ny,2):   to be used for "ILU" matrix of "P5(*,1)"
! P3(3*nx*ny,1:2): the directional matrices for the pressure
!                  (algorithm is not yet developed to utilize them)
! Q1(0:nx,ny): the "U" component of STEP1 from the former time level
! Q2(nx,0:ny): the "V" component of STEP1 from the former time level
! b(*): the RHS to be used solvers for velocity and pressure
! P0(nx,ny,2): the array for saving pressure of two former time levels
!-----------------------------------------------------------------------

!---- local variables

      integer level0
      real*4  utime0,stime0,utime1,stime1
      real*8  tn,hxmin,hxmax,hymin,hymax,zero
      character*5 DIS

      if(idPois_Dis.eq.1)then
          DIS='FVM'
      else if(idPois_Dis.eq.2)then
          DIS='FDM'
      else
          stop 'driver.f: idPois_Dis=1 or 2'
      endif

!---- Informing: stdout

      if(level.ge.1)then
          print'("DRIVER: idsol_op=",i1," idsol_uv=",i1
     &           ," idsol_pr=",i1)', idsol_op,idsol_uv,idsol_pr
         if(idsol_op.eq.1) print*,"Old-FTS: Choi-Moin"
         if(idsol_op.eq.2) print*,"New-FTS: S.Kim"
         if(idsol_uv.eq.1) print*,"Velocity Solve: SIP Method"
         if(idsol_pr.eq.1) print*,"Pressure Solve: PCG-ILU0"
      endif
      if(level.ge.2) then
         print*,"nx=",nx," ax=",ax," bx=",bx
         print*,"ny=",ny," ay=",ay," by=",by
         print*,"nt=",nt," at=",at," bt=",bt
         print*,"density=",density," visco=",visco," vlid=",vlid
         print*,"id_Steady=",id_Steady," id_BC=",id_BC
     &         ," auto_dt=",auto_dt," grid_fac=",grid_fac
         print*,"alpha=",alpha," beta=",beta," eta=",eta," tol=",tol
      endif

      call etimef77(utime0,stime0)

!---- Local Setting

      level0=level-1
      zero=0.d0


!---- Cartesian grid generation 

      call grid2(nx,ny,level0,ierr,ax,bx,ay,by,grid_fac,
     &           hxmin,hxmax,hymin,hymax,X,Y)


!---- Initialization: "XC,YC,rho,mu,U,V,P,Q1,Q2,P0"

      call init(nx,ny,level0,ierr,density,visco,vlid,
     &          X,Y,XC,YC,rho,mu,U,V,P,Q1,Q2,P0)

!---- Set BC : "BCE,BCW,BCN,BCS"

      call getBC(id_BC,nx,ny,level0,ierr,
     &         zero,zero,zero,zero,zero,zero,vlid,zero,
     &         BCE,BCW,BCN,BCS)

!---- Get the matrix for "Poisson Solver"

      call pmatrix(nx,ny,idPois_Dis,level0,ierr,
     &             DIS,X,Y,XC,YC,P3,P3(1,2),P5)

      if(ierr.ne.0)then
         print*,"driver.f: Error before calling opersplit"
         return
      endif

!--------------------------------------
!---- Now, begin "OPERATOR SPLITTING"
!--------------------------------------

      call opersplit(nt,nx,ny,id_Steady,id_BC,auto_dt,level,ierr,
     &       idsol_op,idsol_uv,idsol_pr,itmax,
     &       density,visco,vlid,tn,
     &       at,bt,ax,bx,ay,by,grid_fac,alpha,beta,eta,tol,
     &       X,Y,XC,YC,rho,mu,U,V,P,
     &       V5,P3,P5,BCE,BCW,BCN,BCS,
     &       Q1,Q2,b,P0,wksp,ws0)


!---- Check the elapsed time

      if(level.le.0)return
      call etimef77(utime1,stime1)
      print'("Elapsed Time=",f8.2)',utime1-utime0


!---- Print information one more time

      if(level.ge.1)then
         open(68,file="fort.1")
         write(68,*) nt,nx,ny
         write(68,*) idsol_op,idsol_uv,idsol_pr
         write(68,*) density,visco,vlid,tn
         write(68,*) alpha,beta,eta
         close(68)
      endif

      if(level.ge.1) then
         print'("PARAMETERS:")'
         print*,"idsol_op=",idsol_op," idsol_uv=",idsol_uv
     &         ," idsol_pr=",idsol_pr
         print*,"id_Steady=",id_Steady," id_BC=",id_BC
     &         ," auto_dt=",auto_dt," grid_fac=",grid_fac
         print*,"idPois_Dis=",idPois_Dis," ",DIS
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",(bx-ax)/nx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",(by-ay)/ny
         print*,"nt=",nt," at=",at," bt=",bt," ht=",(bt-at)/nt
         print*,"density=",density," visco=",visco," vlid=",vlid
         print*,"alpha=",alpha," beta=",beta," eta=",eta," tol=",tol
         print'(" hxmin=",e8.2," hxmax=",e8.2
     &         ," hymin=",e8.2," hymax=",e8.2)',hxmin,hxmax,hymin,hymax
      endif


      return
      end

